package com.atlassian.ozymandias;

import com.atlassian.plugin.ModuleDescriptor;

/**
 * This interface is a call back function that is invoked when each plugin point is visited
 *
 * @see com.atlassian.ozymandias.SafePluginPointAccess
 */
public interface PluginPointVisitor<MT>
{
    /**
     * As each plugin module is visited, this call back function is invoked
     *
     * @param moduleDescriptor the module descriptor in play that contains modules of type MT
     * @param module the module from that module descriptor which is of type MT.  This can be null if modules are not returned by a module
     * descriptor.
     */
    void visit(ModuleDescriptor<MT> moduleDescriptor, MT module);
}
