package com.atlassian.ozymandias;

import com.atlassian.plugin.ModuleDescriptor;

/**
 * This interface is a call back function that is invoked when each plugin point is visited
 *
 * @see SafePluginPointAccess
 */
public interface PluginPointFunction<MT, RT>
{
    /**
     * As each plugin module is visited, this call back function is invoked and you can return a result from that
     * function.
     *
     * @param moduleDescriptor the module descriptor in play that contains modules of type MT
     * @param module the module from that module descriptor which is of type MT.  This can be null if modules are not returned by a module
     * descriptor.
     * @return a result of some type from performing this function
     */
    RT onModule(ModuleDescriptor<MT> moduleDescriptor, MT module);
}
