/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.BrowserType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum BrowserVersion implements Comparable<BrowserVersion>
{
    FIREFOX_3_5(BrowserType.FIREFOX, "3.5"),
    FIREFOX_3_6(BrowserType.FIREFOX, "3.6"),
    CHROME_5(BrowserType.CHROME, "5"),
    CHROME_6(BrowserType.CHROME, "6"),
    CHROME_7(BrowserType.CHROME, "7");

    private final BrowserType browser;
    private final String version;

    private BrowserVersion(BrowserType browser, String version) {
        this.browser = browser;
        this.version = version;
    }

    public String getBrowserName() {
        return this.browser.getName() + "-" + this.version;
    }

    public BrowserType getBrowser() {
        return this.browser;
    }

    public String getVersion() {
        return this.version;
    }

    public static BrowserVersion typeOf(String browserStr) {
        BrowserType type = BrowserType.typeOf(browserStr);
        if (type == null) {
            return null;
        }
        for (BrowserVersion browser : BrowserVersion.values()) {
            String browserVersionName;
            if (!browser.browser.equals((Object)type) || !(browserVersionName = browser.getBrowserName()).equals(browserStr)) continue;
            return browser;
        }
        return null;
    }
}

