/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserVersion;
import com.atlassian.browsers.InstallConfigurator;
import com.atlassian.browsers.Utils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.Validate;

class DefaultBrowserInstallConfigurator
extends InstallConfigurator {
    InstallConfigurator clientInstallConfigurator;

    protected DefaultBrowserInstallConfigurator(InstallConfigurator clientInstallConfigurator) {
        Validate.notNull((Object)clientInstallConfigurator, (String)"The clientInstallConfigurator cannot be null");
        this.clientInstallConfigurator = clientInstallConfigurator;
    }

    public void setupBrowser(BrowserVersion browser, BrowserConfig browserConfig) {
        switch (browser) {
            case FIREFOX_3_5: 
            case FIREFOX_3_6: {
                this.setupFirefoxBrowser(browserConfig);
                break;
            }
            case CHROME_5: 
            case CHROME_6: 
            case CHROME_7: {
                this.setupChromeBrowser(browserConfig);
                break;
            }
            default: {
                throw new RuntimeException("BrowserInstaller does not handle browser: " + browser.getBrowserName());
            }
        }
    }

    public void setupFirefoxBrowser(BrowserConfig browserConfig) {
        this.clientInstallConfigurator.setupFirefoxBrowser(browserConfig);
    }

    public void setupChromeBrowser(BrowserConfig browserConfig) {
        try {
            File gch = Utils.findFile(browserConfig.getBrowserPath(), "Google Chrome Helper", false);
            if (gch == null) {
                gch = Utils.findFile(browserConfig.getBrowserPath(), "chrome", false);
            }
            Utils.make755(gch);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to apply permissions to Google Chrome Helper", e);
        }
        this.clientInstallConfigurator.setupChromeBrowser(browserConfig);
    }
}

