/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.ProcessRunner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;

public class Utils {
    private static final int BUFFER = 2048;

    private Utils() {
    }

    public static void make755(File file) throws IOException {
        ProcessRunner.runProcess(new ProcessBuilder("chmod", "755", file.getCanonicalPath()));
    }

    public static File findFile(File in, final String file, final boolean exactMatch) throws IOException {
        File[] dirs;
        File[] files = in.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                boolean isDir = new File(dir, name).isDirectory();
                if (exactMatch) {
                    return !isDir && name.equals(file);
                }
                return !isDir && name.contains(file);
            }
        });
        if (files.length > 0) {
            return files[0];
        }
        for (File dir : dirs = in.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            File f = Utils.findFile(dir, file, exactMatch);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    public static boolean resourceExists(String path) {
        InputStream internalStream = Utils.class.getResourceAsStream(path);
        return internalStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extractZip(File destDir, String internalPath) throws IOException {
        InputStream internalStream = null;
        File targetDir = new File(destDir, internalPath.substring(internalPath.lastIndexOf(47), internalPath.length() - ".zip".length()));
        if (targetDir.exists()) {
            return targetDir;
        }
        try {
            ZipEntry entry;
            System.out.println("unzipping " + internalPath);
            targetDir.mkdirs();
            internalStream = Utils.class.getResourceAsStream(internalPath);
            if (internalStream == null) {
                throw new IOException("Zip file not found: " + internalPath);
            }
            BufferedOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(internalStream));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                if (entry.getName().endsWith("/")) {
                    new File(targetDir, entry.getName()).mkdirs();
                    continue;
                }
                FileOutputStream fos = new FileOutputStream(new File(targetDir, entry.getName()));
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(internalStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)internalStream);
        return targetDir;
    }
}

