/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserType;
import com.atlassian.browsers.BrowserVersion;
import com.atlassian.browsers.DefaultBrowserInstallConfigurator;
import com.atlassian.browsers.OS;
import com.atlassian.browsers.OsValidator;
import com.atlassian.browsers.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum BrowserInstaller {
    FIREFOX_WINDOWS_3_5(BrowserVersion.FIREFOX_3_5, OS.WINDOWS, "firefox.exe"),
    FIREFOX_LINUX_3_5(BrowserVersion.FIREFOX_3_5, OS.LINUX, "firefox-bin"),
    FIREFOX_LINUX_3_6(BrowserVersion.FIREFOX_3_6, OS.LINUX, "firefox-bin"),
    FIREFOX_OSX_3_5(BrowserVersion.FIREFOX_3_5, OS.OSX, "Contents/MacOS/firefox-bin"),
    FIREFOX_OSX_3_6(BrowserVersion.FIREFOX_3_6, OS.OSX, "Contents/MacOS/firefox-bin"),
    CHROME_LINUX_6(BrowserVersion.CHROME_6, OS.LINUX, "chrome"),
    CHROME_MAC_5(BrowserVersion.CHROME_5, OS.OSX, "Contents/MacOS/chrome-bin"),
    CHROME_MAC_7(BrowserVersion.CHROME_7, OS.OSX, "Contents/MacOS/chrome-bin");

    private static final Logger log;
    private final BrowserVersion browser;
    private final OS os;
    private final String binaryPath;
    private static final Map<OS, ImmutableList<BrowserVersion>> BROWSERS;

    private BrowserInstaller(BrowserVersion browser, OS os, String binaryPath) {
        this.browser = browser;
        this.os = os;
        this.binaryPath = binaryPath;
    }

    public BrowserVersion getBrowser() {
        return this.browser;
    }

    public OS getOS() {
        return this.os;
    }

    public String getOsDirName() {
        return this.os == null ? "ALL" : this.os.getName();
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    private static BrowserInstaller findBrowserInstaller(BrowserVersion browserVersion, OS os) {
        for (BrowserInstaller installer : BrowserInstaller.values()) {
            if (!installer.browser.equals(browserVersion) || !installer.os.equals((Object)os)) continue;
            return installer;
        }
        log.info("Unable to find browser installer for browser {} on OS {}", (Object)browserVersion, (Object)os);
        return null;
    }

    public static BrowserInstaller typeOf(String browserStr) {
        OS os = OS.getType();
        BrowserType browserType = BrowserType.typeOf(browserStr);
        BrowserVersion browserVer = BrowserVersion.typeOf(browserStr);
        if (browserVer == null && browserType != null && browserType.getName().equals(browserStr)) {
            ArrayList<BrowserVersion> browserVersions = new ArrayList<BrowserVersion>();
            for (BrowserVersion browserVersion : BROWSERS.get((Object)os)) {
                if (!browserVersion.getBrowser().equals((Object)browserType)) continue;
                browserVersions.add(browserVersion);
            }
            if (browserVersions.size() > 0) {
                Collections.sort(browserVersions);
                return BrowserInstaller.findBrowserInstaller((BrowserVersion)browserVersions.get(browserVersions.size() - 1), os);
            }
            log.info("No installer for browser {}", (Object)browserType);
        } else if (browserVer != null) {
            if (!BrowserInstaller.isBrowserSupportedForOs(browserVer)) {
                throw new RuntimeException(String.format("Unsupported browser {} for OS {}", new Object[]{browserVer, os}));
            }
            return BrowserInstaller.findBrowserInstaller(browserVer, os);
        }
        log.info("There are no browser installers for browser string {}", (Object)browserStr);
        return null;
    }

    public static boolean isBrowserSupportedForOs(BrowserVersion browserVersion) {
        OS os = OS.getType();
        List supportedOsBrowsers = (List)BROWSERS.get((Object)os);
        return supportedOsBrowsers.contains(browserVersion);
    }

    public void install(File destDir, DefaultBrowserInstallConfigurator installConfigurator) {
        String browserName = this.browser.getBrowserName();
        String binaryPath = this.getBinaryPath();
        String osDirName = this.getOsDirName();
        String profileName = browserName + "-profile";
        String browserResource = "/" + osDirName + "/" + browserName + ".zip";
        String profileResource = "/" + osDirName + "/" + profileName + ".zip";
        File browserProfile = null;
        try {
            File browserDir = Utils.extractZip(destDir, browserResource);
            if (Utils.resourceExists(profileResource)) {
                browserProfile = Utils.extractZip(destDir, profileResource);
            }
            File browserBinary = new File(browserDir, binaryPath);
            if (!OsValidator.isWindows()) {
                Utils.make755(browserBinary);
            }
            BrowserConfig browserConfig = new BrowserConfig(browserDir, browserBinary, browserProfile);
            installConfigurator.setupBrowser(this.browser, browserConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        log = LoggerFactory.getLogger(BrowserInstaller.class);
        BROWSERS = ImmutableMap.of((Object)((Object)OS.WINDOWS), (Object)ImmutableList.of((Object)BrowserVersion.FIREFOX_3_5), (Object)((Object)OS.LINUX), (Object)ImmutableList.of((Object)BrowserVersion.FIREFOX_3_5, (Object)BrowserVersion.CHROME_6), (Object)((Object)OS.OSX), (Object)ImmutableList.of((Object)BrowserVersion.FIREFOX_3_5, (Object)BrowserVersion.FIREFOX_3_6, (Object)BrowserVersion.CHROME_5, (Object)BrowserVersion.CHROME_7));
    }
}

