package com.atlassian.browsers;

/**
 * Defines the available browser versions.
 */
public enum BrowserVersion implements Comparable<BrowserVersion>
{
    FIREFOX_3_5(BrowserType.FIREFOX, "3.5"),
    FIREFOX_3_6(BrowserType.FIREFOX, "3.6"),
    CHROME_5(BrowserType.CHROME, "5"),
    CHROME_6(BrowserType.CHROME, "6"),
    CHROME_7(BrowserType.CHROME, "7");

    private final BrowserType browser;
    private final String version;

    BrowserVersion(BrowserType browser, String version)
    {
        this.browser = browser;
        this.version = version;
    }

    public String getBrowserName()
    {
        return browser.getName() + "-" + version;
    }

    public BrowserType getBrowser()
    {
        return browser;
    }

    public String getVersion()
    {
        return version;
    }

    /**
     * Determines the browser version based on the browser string passed in.
     * @param browserStr The browser string to check
     * @return The BrowserVersion enum or null if it's not found.
     */
    public static BrowserVersion typeOf(String browserStr)
    {

        BrowserType type = BrowserType.typeOf(browserStr);
        if (type == null)
        {
            return null;
        }

        for (BrowserVersion browser : BrowserVersion.values())
        {

            if (browser.browser.equals(type))
            {
                String browserVersionName = browser.getBrowserName();

                if (browserVersionName.equals(browserStr))
                {
                    return browser;
                }

            }

        }

        return null;
    }
}
