/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ProcessRunner {
    public static void runProcess(ProcessBuilder procBuilder) {
        ProcessRunner.runProcess(procBuilder, null, false);
    }

    public static Process runProcessInBackground(ProcessBuilder procBuilder, File outputFile) {
        return ProcessRunner.runProcess(procBuilder, outputFile, true);
    }

    public static Process runProcess(ProcessBuilder procBuilder, File outputFile, boolean background) {
        Process proc = null;
        try {
            System.out.println("Executing " + procBuilder.command());
            proc = procBuilder.start();
            if (outputFile != null) {
                procBuilder.redirectErrorStream(true);
                StreamReader reader = new StreamReader(proc.getInputStream(), new FileOutputStream(outputFile));
                reader.start();
            }
            if (!background) {
                proc.waitFor();
                if (proc.exitValue() != 0) {
                    throw new RuntimeException("Unable to execute " + procBuilder.toString() + " as returned error code " + proc.exitValue());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start process", e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return proc;
    }

    static class StreamReader
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public StreamReader(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buffer = new byte[512];
            try {
                int len;
                while ((len = this.in.read(buffer)) > 0) {
                    this.out.write(buffer, 0, len);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.in);
                IOUtils.closeQuietly((OutputStream)this.out);
            }
        }
    }
}

