/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserVersion;
import com.atlassian.browsers.DefaultBrowserInstallConfigurator;
import com.atlassian.browsers.OS;
import com.atlassian.browsers.OsValidator;
import com.atlassian.browsers.Utils;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum BrowserInstaller {
    FIREFOX_WINDOWS_3_5(BrowserVersion.FIREFOX_3_5, OS.WINDOWS, "firefox.exe"),
    FIREFOX_LINUX_3_5(BrowserVersion.FIREFOX_3_5, OS.LINUX, "firefox-bin"),
    FIREFOX_OSX_3_5(BrowserVersion.FIREFOX_3_5, OS.OSX, "Contents/MacOS/firefox-bin"),
    FIREFOX_OSX_3_6(BrowserVersion.FIREFOX_3_6, OS.OSX, "Contents/MacOS/firefox-bin"),
    CHROME_LINUX_6(BrowserVersion.CHROME_6, OS.LINUX, "chrome"),
    CHROME_MAC_5(BrowserVersion.CHROME_5, OS.OSX, "Contents/MacOS/chrome-bin"),
    IE_ALL(BrowserVersion.IE, OS.WINDOWS, "");

    private final BrowserVersion browser;
    private final OS os;
    private final String binaryPath;

    private BrowserInstaller(BrowserVersion browser, OS os, String binaryPath) {
        this.browser = browser;
        this.os = os;
        this.binaryPath = binaryPath;
    }

    public BrowserVersion getBrowser() {
        return this.browser;
    }

    public OS getOS() {
        return this.os;
    }

    public String getOsDirName() {
        return this.os.getName();
    }

    public String getBinaryPath() {
        return this.binaryPath;
    }

    public static BrowserInstaller typeOf(String browserStr) {
        OS os = OS.getType();
        BrowserVersion browserVer = BrowserVersion.typeOf(browserStr);
        for (BrowserInstaller browserInstaller : BrowserInstaller.values()) {
            if (!browserInstaller.browser.equals((Object)browserVer) || !browserInstaller.os.equals((Object)os)) continue;
            return browserInstaller;
        }
        return null;
    }

    public void install(File destDir, DefaultBrowserInstallConfigurator installConfigurator) {
        String browserName = this.browser.getBrowserName();
        String binaryPath = this.getBinaryPath();
        String osDirName = this.getOsDirName();
        String profileName = browserName + "-profile";
        String browserResource = "/" + osDirName + "/" + browserName + ".zip";
        String profileResource = "/" + osDirName + "/" + profileName + ".zip";
        File browserProfile = null;
        try {
            File browserDir = Utils.extractZip(destDir, browserResource);
            if (Utils.resourceExists(profileResource)) {
                browserProfile = Utils.extractZip(destDir, profileResource);
            }
            File browserBinary = new File(browserDir, binaryPath);
            if (!OsValidator.isWindows()) {
                Utils.make755(browserBinary);
            }
            BrowserConfig browserConfig = new BrowserConfig(browserDir, browserBinary, browserProfile);
            installConfigurator.setupBrowser(this.browser, browserConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

