/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.BrowserConfiguration;
import com.atlassian.browsers.BrowserInstaller;
import com.atlassian.browsers.DefaultBrowserInstallConfigurator;
import com.atlassian.browsers.InstallConfigurator;
import com.atlassian.browsers.OsValidator;
import com.atlassian.browsers.XvfbManager;
import java.io.File;
import org.apache.commons.lang.Validate;

public class BrowserAutoInstaller {
    private static boolean useXvfb = Boolean.parseBoolean(System.getProperty("xvfb.enable", "false"));
    private XvfbManager xvfbManager;
    public static final String CHROME_XVFB = "chromeXvfb";
    private BrowserConfiguration browserConfiguration;
    private DefaultBrowserInstallConfigurator installConfigurator;

    public BrowserAutoInstaller(BrowserConfiguration browserConfiguration, InstallConfigurator configurator) {
        Validate.notNull((Object)browserConfiguration, (String)"Browser Configuration can not be null.");
        Validate.notNull((Object)configurator, (String)"The Install configurator cannot be null.");
        this.browserConfiguration = browserConfiguration;
        this.installConfigurator = new DefaultBrowserInstallConfigurator(configurator);
    }

    public void setupBrowser() {
        BrowserInstaller browserInstaller;
        File tmpDir = this.browserConfiguration.getTmpDir();
        tmpDir.mkdirs();
        this.createXvfbManager(tmpDir);
        String display = this.xvfbManager.getDisplay();
        if (OsValidator.isUnix() && display != null) {
            System.setProperty("DISPLAY", display);
        }
        if ((browserInstaller = BrowserInstaller.typeOf(this.browserConfiguration.getBrowserName())).getBrowser().getBrowserName() != "*iexplore") {
            browserInstaller.install(tmpDir, this.installConfigurator);
        }
    }

    private void createXvfbManager(File tmpDir) {
        final XvfbManager xvfb = new XvfbManager(tmpDir);
        if (useXvfb && OsValidator.isUnix()) {
            xvfb.start();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    xvfb.stop();
                }
            });
        }
        this.xvfbManager = xvfb;
    }
}

