/*
 * Decompiled with CFR 0.152.
 */
package at.shanakor.executor.impl;

import at.shanakor.executor.Executor;
import at.shanakor.interactors.base.AbstractInteractor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadExecutor
implements Executor {
    private static volatile ThreadExecutor threadExecutor;
    private static final int CORE_POOL_SIZE = 3;
    private static final int MAX_POOL_SIZE = 5;
    private static final int KEEP_ALIVE_TIME = 120;
    private static final TimeUnit TIME_UNIT;
    private static final BlockingQueue<Runnable> WORK_QUEUE;
    private ThreadPoolExecutor threadPoolExecutor;

    private ThreadExecutor() {
        long keepAlive = 120L;
        this.threadPoolExecutor = new ThreadPoolExecutor(3, 5, keepAlive, TIME_UNIT, WORK_QUEUE);
    }

    public void execute(final AbstractInteractor interactor) {
        if (interactor == null) {
            throw new IllegalArgumentException("The parameter 'interactor' can not be null!");
        }
        this.threadPoolExecutor.submit(new Runnable(){

            public void run() {
                interactor.run();
                interactor.onFinished();
            }
        });
    }

    public static synchronized Executor getInstance() {
        if (threadExecutor == null) {
            threadExecutor = new ThreadExecutor();
        }
        return threadExecutor;
    }

    static {
        TIME_UNIT = TimeUnit.SECONDS;
        WORK_QUEUE = new LinkedBlockingQueue<Runnable>();
    }
}

