/*
 * Decompiled with CFR 0.152.
 */
package at.shanakor;

import at.shanakor.Method;
import at.shanakor.Property;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Interactor {
    private final String name;
    private final List<Property> properties;
    private final List<Method> callBackMethods;

    public Interactor(String fullyQualifiedName, List<Property> properties, Method ... callBackMethods) {
        if (fullyQualifiedName == null) {
            throw new IllegalArgumentException("The parameter 'fullyQualifiedName' can not be null!");
        }
        this.name = fullyQualifiedName;
        this.properties = properties != null ? properties : new LinkedList<Property>();
        this.callBackMethods = Arrays.asList(callBackMethods);
    }

    public String getSimpleName() {
        String[] splitName = this.name.split("\\.");
        return splitName[splitName.length - 1];
    }

    public String getPackage() {
        String[] splitName = this.name.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < splitName.length - 1; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(splitName[i]);
        }
        return sb.toString();
    }

    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public Method[] getCallBackMethods() {
        return this.callBackMethods.toArray(new Method[this.callBackMethods.size()]);
    }
}

