/*
 * Decompiled with CFR 0.152.
 */
package at.shanakor;

import at.shanakor.Interactor;
import at.shanakor.Method;
import at.shanakor.Property;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Presenter {
    private final String fullyQualifiedName;
    private final List<Method> methods;
    private String fullyQualifiedInteractorName;
    private Interactor interactor;
    private List<Property> properties;
    private List<Method> callBackMethods;

    private Presenter(String fullyQualifiedName, List<Method> methods) {
        if (fullyQualifiedName == null) {
            throw new IllegalArgumentException("The parameter 'fullyQualifiedName' can not be null!");
        }
        if (methods == null) {
            throw new IllegalArgumentException("The parameter 'methods' can not be null!");
        }
        this.fullyQualifiedName = fullyQualifiedName;
        this.methods = methods;
    }

    public Presenter(String fullyQualifiedName, String fullyQualifiedInteractorname, List<Property> properties, List<Method> methods, Method ... callBackMethods) {
        this(fullyQualifiedName, methods);
        if (fullyQualifiedInteractorname == null) {
            throw new IllegalArgumentException("The parameter 'fullyQualifiedInteractorname' can not be null!");
        }
        if (properties == null) {
            throw new IllegalArgumentException("The parameter 'properties' can not be null!");
        }
        if (callBackMethods == null) {
            throw new IllegalArgumentException("The parameter 'callBackMethods' can not be null!");
        }
        this.fullyQualifiedInteractorName = fullyQualifiedInteractorname;
        this.properties = properties;
        this.callBackMethods = Arrays.asList(callBackMethods);
    }

    public Presenter(String fullyQualifiedName, Interactor interactor, List<Method> methods) {
        this(fullyQualifiedName, methods);
        if (interactor == null) {
            throw new IllegalArgumentException("The parameter 'interactor' can not be null!");
        }
        this.interactor = interactor;
    }

    public String getSimpleName() {
        String[] splitName = this.fullyQualifiedName.split("\\.");
        return splitName[splitName.length - 1];
    }

    public String getPackage() {
        String[] splitName = this.fullyQualifiedName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < splitName.length - 1; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(splitName[i]);
        }
        return sb.toString();
    }

    public Property[] getProperties() {
        if (this.interactor != null) {
            return this.interactor.getProperties();
        }
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public Method[] getCallBackMethods() {
        if (this.interactor != null) {
            return this.interactor.getCallBackMethods();
        }
        return this.callBackMethods.toArray(new Method[this.callBackMethods.size()]);
    }

    public Method[] getMethods() {
        return this.methods.toArray(new Method[this.methods.size()]);
    }

    public Interactor getInteractor() {
        return this.interactor;
    }

    public String getFullyQualifiedInteractorName() {
        return this.fullyQualifiedInteractorName;
    }
}

