/*
 * Decompiled with CFR 0.152.
 */
package at.shanakor;

import at.shanakor.FileUtils;
import at.shanakor.Interactor;
import at.shanakor.Method;
import at.shanakor.Presenter;
import at.shanakor.Property;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaInterface;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractorGenerator {
    private String presenterPath;
    private String domainPath;
    private final String basePackage;
    private final List<Presenter> presenters;
    private JavaInterfaceSource interactorInterface;
    private JavaInterfaceSource interactorInterfaceCallback;
    private JavaClassSource interactorImpl;
    private JavaInterfaceSource presenterInterface;
    private JavaInterfaceSource presenterInterfaceCallback;
    private JavaClassSource presenterImpl;

    private InteractorGenerator(String basePackage) {
        if (basePackage == null) {
            throw new IllegalArgumentException("The parameter 'basePackage' can not be null!");
        }
        if (basePackage.isEmpty()) {
            throw new IllegalArgumentException("The parameter 'basePackage' can not be empty!");
        }
        this.basePackage = basePackage + ".";
        this.presenters = new LinkedList<Presenter>();
    }

    public InteractorGenerator(String basePackage, String appPath) {
        this(basePackage);
        if (appPath == null) {
            throw new IllegalArgumentException("The parameter 'appPath' can not be null!");
        }
        if (!FileUtils.isFilePathValid(appPath)) {
            throw new IllegalArgumentException("The 'appPath' you specified is not valid!");
        }
        this.presenterPath = appPath;
        this.domainPath = appPath;
    }

    public InteractorGenerator(String basePackage, String presenterPath, String domainPath) {
        this(basePackage);
        if (presenterPath == null) {
            throw new IllegalArgumentException("The parameter 'presenterPath' can not be null!");
        }
        if (!FileUtils.isFilePathValid(presenterPath)) {
            throw new IllegalArgumentException("The 'presenterPath' you specified is not valid!");
        }
        if (domainPath == null) {
            throw new IllegalArgumentException("The parameter 'domainPath' can not be null!");
        }
        if (!FileUtils.isFilePathValid(domainPath)) {
            throw new IllegalArgumentException("The 'domainPath' you specified is not valid!");
        }
        this.presenterPath = presenterPath;
        this.domainPath = domainPath;
    }

    public void addAllPresenters(List<Presenter> presenters) {
        if (presenters == null) {
            throw new IllegalArgumentException("The parameter 'presenters' can not be null!");
        }
        for (Presenter presenter : presenters) {
            this.addPresenter(presenter);
        }
    }

    public void addPresenter(Presenter presenter) {
        if (presenter == null) {
            throw new IllegalArgumentException("The parameter 'presenter' can not be null!");
        }
        this.presenters.add(presenter);
    }

    public void generateAll() {
        try {
            for (Presenter presenter : this.presenters) {
                Interactor interactor = presenter.getInteractor();
                if (interactor != null) {
                    this.setUpInteractorInterface(interactor);
                    FileUtils.interfaceToFile(this.interactorInterface, new File(this.domainPath));
                    this.setUpInteractorImpl(interactor);
                    FileUtils.classToFile(this.interactorImpl, new File(this.domainPath));
                }
                this.setUpPresenterInterface(presenter);
                FileUtils.interfaceToFile(this.presenterInterface, new File(this.presenterPath));
                this.setUpPresenterImpl(presenter);
                FileUtils.classToFile(this.presenterImpl, new File(this.presenterPath));
                this.interactorInterfaceCallback = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void setUpPresenterImpl(Presenter presenter) {
        try {
            this.presenterImpl = (JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setPackage(this.basePackage + presenter.getPackage() + ".impl")).setName(presenter.getSimpleName() + "Impl");
            this.setUpPresenterProperties(presenter);
            this.setUpPresenterConstructor(presenter);
            ((JavaClassSource)this.presenterImpl.extendSuperType(Class.forName(this.basePackage + "base.AbstractPresenter"))).addInterface((JavaInterface)this.presenterInterface);
            if (this.interactorInterfaceCallback != null) {
                this.presenterImpl.addInterface((JavaInterface)this.interactorInterfaceCallback);
            } else {
                this.presenterImpl.addInterface(Class.forName(this.basePackage + presenter.getFullyQualifiedInteractorName() + "$Callback"));
            }
        }
        catch (ClassNotFoundException e) {
            this.logClassNotFound(e.getMessage());
        }
    }

    private void setUpPresenterConstructor(Presenter presenter) throws ClassNotFoundException {
        MethodSource constructor = (MethodSource)this.presenterImpl.addMethod().setConstructor(true).setPublic();
        this.setUpPresenterConstructorParams(presenter, constructor);
        this.setUpPresenterConstructorBody(presenter, constructor);
    }

    private void setUpPresenterConstructorBody(Presenter presenter, MethodSource constructor) {
        int i;
        String body = "super(executor, mainThread);\r\nif(view == null)\r\n   throw new IllegalArgumentException(\"The parameter 'view' can not be null!\");\r\n";
        Property[] params = presenter.getProperties();
        for (i = 0; i < params.length; ++i) {
            if (!(params[i].getType() instanceof Object)) continue;
            body = body + "if(" + params[i].getName() + " == null)\r\n" + "   throw new IllegalArgumentException(\"The parameter '" + params[i].getName() + "' can not be null!\");\r\n";
        }
        body = body + " \r\n";
        body = body + "this.view = view;\r\n";
        for (i = 0; i < params.length; ++i) {
            body = body + "this." + params[i].getName() + " = " + params[i].getName() + ";\r\n";
        }
        constructor.setBody(body);
    }

    private void setUpPresenterConstructorParams(Presenter presenter, MethodSource constructor) throws ClassNotFoundException {
        constructor.addParameter(Class.forName(this.basePackage + "executor.Executor"), "executor");
        constructor.addParameter(Class.forName(this.basePackage + "executor.MainThread"), "mainThread");
        constructor.addParameter((JavaType)this.presenterInterfaceCallback, "view");
        Property[] params = presenter.getProperties();
        for (int i = 0; i < params.length; ++i) {
            constructor.addParameter(params[i].getType(), params[i].getName());
        }
    }

    private void setUpPresenterProperties(Presenter presenter) {
        this.presenterImpl.addProperty((JavaType)this.presenterInterfaceCallback, "view").setAccessible(false).setMutable(false);
        Property[] properties = presenter.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            this.presenterImpl.addProperty(properties[i].getType(), properties[i].getName()).setAccessible(false).setMutable(false);
        }
    }

    private void setUpPresenterInterface(Presenter presenter) {
        try {
            this.presenterInterface = (JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)Roaster.create(JavaInterfaceSource.class)).setPackage(this.basePackage + presenter.getPackage())).setName(presenter.getSimpleName())).addInterface(Class.forName(this.basePackage + "base.BasePresenter"));
            this.presenterInterface.addImport(Class.forName(this.basePackage + "base.BaseView"));
            this.setUpPresenterInterfaceCallback(presenter);
            this.setUpPresenterInterfaceMethods(presenter);
        }
        catch (ClassNotFoundException e) {
            this.logClassNotFound(e.getMessage());
        }
    }

    private void setUpPresenterInterfaceMethods(Presenter presenter) {
        Method[] methods = presenter.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            MethodSource method = this.presenterInterface.addMethod();
            method.setReturnType(methods[i].getReturnType()).setName(methods[i].getName());
            Property[] params = methods[i].getParams();
            for (int j = 0; j < params.length; ++j) {
                method.addParameter(params[j].getType(), params[j].getName());
            }
        }
    }

    private void setUpPresenterInterfaceCallback(Presenter presenter) {
        try {
            this.presenterInterfaceCallback = (JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)Roaster.create(JavaInterfaceSource.class)).setPackage(this.basePackage + presenter.getPackage() + "." + presenter.getSimpleName())).setName("View")).setPackagePrivate()).addInterface(Class.forName(this.basePackage + "base.BaseView"));
            Method[] callbackMethods = presenter.getCallBackMethods();
            for (int i = 0; i < callbackMethods.length; ++i) {
                MethodSource method = ((MethodSource)this.presenterInterfaceCallback.addMethod().setName(callbackMethods[i].getName())).setReturnType(callbackMethods[i].getReturnType());
                Property[] params = callbackMethods[i].getParams();
                for (int j = 0; j < params.length; ++j) {
                    method.addParameter(params[j].getType(), params[j].getName());
                }
            }
            this.presenterInterface.addNestedType((JavaSource)this.presenterInterfaceCallback);
        }
        catch (ClassNotFoundException e) {
            this.logClassNotFound(e.getMessage());
        }
    }

    private void setUpInteractorImpl(Interactor interactor) {
        try {
            this.interactorImpl = (JavaClassSource)Roaster.create(JavaClassSource.class);
            ((JavaClassSource)this.interactorImpl.setPackage(this.basePackage + interactor.getPackage() + ".impl")).setName(interactor.getSimpleName() + "Impl");
            this.setUpInteractorProperties(interactor);
            this.setUpInteractorConstructor(interactor);
            ((JavaClassSource)this.interactorImpl.extendSuperType(Class.forName(this.basePackage + "interactors.base.AbstractInteractor"))).implementInterface((JavaInterface)this.interactorInterface);
        }
        catch (ClassNotFoundException e) {
            this.logClassNotFound(e.getMessage());
        }
    }

    private void setUpInteractorProperties(Interactor interactor) {
        this.interactorImpl.addProperty((JavaType)this.interactorInterfaceCallback, "callback").setAccessible(false).setMutable(false);
        Property[] properties = interactor.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            this.interactorImpl.addProperty(properties[i].getType(), properties[i].getName()).setAccessible(false).setMutable(false);
        }
    }

    private void setUpInteractorConstructor(Interactor interactor) {
        MethodSource constructor = (MethodSource)this.interactorImpl.addMethod().setConstructor(true).setPublic();
        try {
            this.setUpInteractorConstructorParams(interactor, constructor);
            this.setUpInteractorConstructorBody(interactor, constructor);
        }
        catch (ClassNotFoundException e) {
            this.logClassNotFound(e.getMessage());
        }
    }

    private void setUpInteractorConstructorBody(Interactor interactor, MethodSource constructor) {
        int i;
        String body = "super(threadExecutor, mainThread);\r\n\r\nif(callback == null)\r\n   throw new IllegalArgumentException(\"The parameter 'callback' can not be null!\");\r\n";
        Property[] params = interactor.getProperties();
        for (i = 0; i < params.length; ++i) {
            if (!(params[i].getType() instanceof Object)) continue;
            body = body + "if(" + params[i].getName() + " == null)\r\n" + "   throw new IllegalArgumentException(\"The parameter '" + params[i].getName() + "' can not be null!\");\r\n";
        }
        body = body + " \r\n";
        body = body + "this.callback = callback;\r\n";
        for (i = 0; i < params.length; ++i) {
            body = body + "this." + params[i].getName() + " = " + params[i].getName() + ";\r\n";
        }
        constructor.setBody(body);
    }

    private void setUpInteractorConstructorParams(Interactor interactor, MethodSource constructor) throws ClassNotFoundException {
        constructor.addParameter(Class.forName(this.basePackage + "executor.Executor"), "threadExecutor");
        constructor.addParameter(Class.forName(this.basePackage + "executor.MainThread"), "mainThread");
        constructor.addParameter((JavaType)this.interactorInterfaceCallback, "callback");
        Property[] properties = interactor.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            constructor.addParameter(properties[i].getType(), properties[i].getName());
        }
    }

    private void setUpInteractorInterface(Interactor interactor) {
        try {
            this.interactorInterface = (JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)Roaster.create(JavaInterfaceSource.class)).setPackage(this.basePackage + interactor.getPackage())).setName(interactor.getSimpleName())).addInterface(Class.forName(this.basePackage + "interactors.base.Interactor"));
            this.setUpInteractorInterfaceCallback(interactor);
        }
        catch (ClassNotFoundException e) {
            this.logClassNotFound(e.getMessage());
        }
    }

    private void setUpInteractorInterfaceCallback(Interactor interactor) {
        this.interactorInterfaceCallback = (JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)((JavaInterfaceSource)Roaster.create(JavaInterfaceSource.class)).setName("Callback")).setPackage(this.basePackage + interactor.getPackage() + "." + interactor.getSimpleName())).setPackagePrivate();
        Method[] callbackMethods = interactor.getCallBackMethods();
        for (int i = 0; i < callbackMethods.length; ++i) {
            this.interactorInterfaceCallback.addMethod().setReturnType(callbackMethods[i].getReturnType()).setName(callbackMethods[i].getName());
        }
        this.interactorInterface.addNestedType((JavaSource)this.interactorInterfaceCallback);
    }

    private void logClassNotFound(String className) {
        Logger.getLogger("").log(Level.SEVERE, "Could not find the class '" + className + "'!");
    }
}

