/*
 * Decompiled with CFR 0.152.
 */
package at.shanakor.interactors.base;

import at.shanakor.executor.Executor;
import at.shanakor.executor.MainThread;
import at.shanakor.interactors.base.Interactor;

public abstract class AbstractInteractor
implements Interactor {
    protected Executor threadExecutor;
    protected MainThread mainThread;
    protected volatile boolean isCanceled;
    protected volatile boolean isRunning;

    public AbstractInteractor(Executor threadExecutor, MainThread mainThread) {
        if (threadExecutor == null) {
            throw new IllegalArgumentException("The parameter 'threadExecutor' can not be null!");
        }
        if (mainThread == null) {
            throw new IllegalArgumentException("The parameter 'mainThread' can not be null!");
        }
        this.threadExecutor = threadExecutor;
        this.mainThread = mainThread;
    }

    public abstract void run();

    public void cancel() {
        this.isCanceled = true;
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void onFinished() {
        this.isRunning = false;
        this.isCanceled = false;
    }

    public void execute() {
        this.isRunning = true;
        this.threadExecutor.execute(this);
    }
}

