/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.nodekeeper.bootstrap;

import at.salzburgresearch.nodekeeper.NodeKeeper;
import at.salzburgresearch.nodekeeper.bootstrap.ZKBootstrap;
import at.salzburgresearch.nodekeeper.exception.NodeKeeperException;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class ZKBootstrapCli {
    private File file;
    private String connection;

    public static void main(String[] args) throws ParseException, InterruptedException, NodeKeeperException, IOException {
        new ZKBootstrapCli(args).exec();
    }

    public ZKBootstrapCli(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.buildOptions(), args);
        }
        catch (MissingOptionException e) {
            System.err.println(e.getMessage());
            this.displayUsage();
        }
        if (line.hasOption("help")) {
            this.displayUsage();
        } else if (line.hasOption("file")) {
            String path = line.getOptionValue("file");
            this.file = new File(path);
            if (!this.file.exists() || !this.file.canRead()) {
                System.err.println("Bootstrap file '" + this.file.getAbsolutePath() + " not found!");
                this.displayUsage();
            }
            this.connection = line.hasOption("connection") ? line.getOptionValue("connection") : "localhost:2181";
        } else {
            System.err.println("Bootstrap file missing!");
            this.displayUsage();
        }
    }

    public void exec() throws InterruptedException, IOException, NodeKeeperException {
        NodeKeeper nodeKeeper = new NodeKeeper(this.connection, 10, new Properties());
        ZKBootstrap zkBootstrap = new ZKBootstrap(nodeKeeper);
        zkBootstrap.load(this.file, true);
        System.out.println("Successfully bootstrapped zookeeper at " + this.connection + " with data from " + this.file.getAbsolutePath() + " !");
    }

    private Options buildOptions() {
        OptionBuilder.withDescription((String)"display help message");
        OptionBuilder.withLongOpt((String)"help");
        Option help = OptionBuilder.create((String)"h");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription((String)"path to bootstrap properties file");
        OptionBuilder.withLongOpt((String)"file");
        Option file = OptionBuilder.create((String)"f");
        OptionBuilder.withArgName((String)"connection");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"connection string to zookeeper (default localhost:2181)");
        OptionBuilder.withLongOpt((String)"connection");
        Option connection = OptionBuilder.create((String)"c");
        Options options = new Options();
        options.addOption(help);
        options.addOption(file);
        options.addOption(connection);
        return options;
    }

    private void displayUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar nodekeeper-java-1.1-onejar.jar", this.buildOptions());
        System.exit(-1);
    }
}

