/*
 * Decompiled with CFR 0.152.
 */
package at.salzburgresearch.nodekeeper.bootstrap;

import at.salzburgresearch.nodekeeper.NodeKeeper;
import at.salzburgresearch.nodekeeper.exception.NodeKeeperException;
import at.salzburgresearch.nodekeeper.model.Node;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ZKBootstrap {
    private NodeKeeper nodeKeeper;

    public ZKBootstrap(NodeKeeper nodeKeeper) {
        this.nodeKeeper = nodeKeeper;
    }

    public void load(File file, boolean clean) throws IOException, NodeKeeperException, InterruptedException {
        this.load(new FileInputStream(file), clean);
    }

    public void load(InputStream is, boolean clean) throws IOException, NodeKeeperException, InterruptedException {
        if (clean) {
            this.cleanNode(new Node("/"));
        }
        Properties properties = new Properties();
        properties.load(is);
        for (Object key : properties.keySet()) {
            Node<String> node = new Node<String>((String)key, (String)properties.get(key));
            this.nodeKeeper.writeNode(node, String.class);
        }
    }

    private void cleanNode(Node node) throws NodeKeeperException, InterruptedException {
        for (Node<String> child : this.nodeKeeper.listChildrenNodes(node.getPath(), String.class)) {
            this.cleanNode(child);
        }
        try {
            this.nodeKeeper.deleteNode(node);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

