/*
 * Decompiled with CFR 0.152.
 */
package at.rocklogic.kafka.serializer;

import at.rocklogic.kafka.configuration.JsonConfiguration;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSerializer<T>
implements Serializer<T> {
    private static final Logger log = LoggerFactory.getLogger(ObjectSerializer.class);
    private static ObjectMapper objectMapper = new JsonConfiguration().objectMapper();

    public void configure(Map<String, ?> map, boolean b) {
    }

    public byte[] serialize(String topic, T dataObject) {
        StopWatch stopWatch = new StopWatch("serialize");
        stopWatch.start("json generation");
        String json = this.buildJson(dataObject);
        stopWatch.stop();
        log.info("json constructed: " + json);
        stopWatch.start("get bytes of json string");
        byte[] encrypted = json.getBytes();
        stopWatch.stop();
        log.debug(stopWatch.prettyPrint());
        return encrypted;
    }

    public void close() {
    }

    private String buildJson(T dataObject) {
        try {
            return objectMapper.writeValueAsString(dataObject);
        }
        catch (JsonProcessingException e) {
            log.error("error occurred while generating json");
            throw new RuntimeException(e);
        }
    }
}

