/*
 * Decompiled with CFR 0.152.
 */
package at.rocklogic.kafka.deserializer;

import at.rocklogic.kafka.TopicMapping;
import at.rocklogic.kafka.configuration.JsonConfiguration;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.serialization.Deserializer;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDeserializer<T>
implements Deserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(ObjectDeserializer.class);
    private Set<Class<?>> topicClasses;
    private static ObjectMapper objectMapper = new JsonConfiguration().objectMapper();

    public ObjectDeserializer() {
        Reflections reflections = new Reflections("", new Scanner[0]);
        this.topicClasses = reflections.getTypesAnnotatedWith(TopicMapping.class);
    }

    public void configure(Map<String, ?> map, boolean b) {
    }

    public T deserialize(String topic, byte[] bytes) {
        StopWatch stopWatch = new StopWatch("deserialize");
        stopWatch.start("kafka topic");
        stopWatch.stop();
        String json = new String(bytes);
        stopWatch.start("parsing json");
        T dataObject = this.parseJson(this.getClassForTopic(topic), json);
        stopWatch.stop();
        log.debug(stopWatch.prettyPrint());
        return dataObject;
    }

    private Class<?> getClassForTopic(String topic) {
        Class<?> topicClass = null;
        for (Class<?> entityClass : this.topicClasses) {
            TopicMapping annotation = entityClass.getAnnotation(TopicMapping.class);
            boolean mappingMatches = false;
            mappingMatches = !StringUtils.isEmpty((Object)annotation.topicPattern()) ? topic.matches(annotation.topicPattern()) : topic.equals(annotation.topic());
            if (!mappingMatches) continue;
            if (topicClass == null) {
                topicClass = entityClass;
                continue;
            }
            throw new RuntimeException("Multiple Classes found for topic " + topic + ". Should only be one Class per topic.");
        }
        if (topicClass == null) {
            throw new RuntimeException("No Class found for topic " + topic + ".");
        }
        return topicClass;
    }

    private T parseJson(Class<?> topicClass, String json) {
        Object dataObject;
        try {
            dataObject = objectMapper.readValue(json, topicClass);
        }
        catch (IOException e) {
            log.error("An error occurred while parsing the payload: ", (Throwable)e);
            dataObject = null;
        }
        return (T)dataObject;
    }

    public void close() {
    }
}

