/*
 * Decompiled with CFR 0.152.
 */
package won.utils.im.port;

import java.io.File;
import java.io.IOException;
import org.apache.jena.rdf.model.Model;
import won.utils.im.port.AtomDataWriter;
import won.utils.im.port.ModelRdfFileWriter;

public class ModelsRdfFolderWriter
implements AtomDataWriter<Model> {
    private File outputFolder;
    private ModelRdfFileWriter fileWriter;
    private int counter;

    public ModelsRdfFolderWriter(String outputFolderPath) throws IOException {
        this.outputFolder = new File(outputFolderPath);
        this.counter = 0;
    }

    @Override
    public void write(Model model) throws IOException {
        String fileName = String.format(String.format("%05d.ttl", this.counter++), new Object[0]);
        File outputFile = new File(this.outputFolder, fileName);
        this.fileWriter = new ModelRdfFileWriter(outputFile);
        this.fileWriter.write(model);
        this.fileWriter.close();
    }

    @Override
    public void close() throws IOException {
        this.fileWriter.close();
    }
}

