/*
 * Decompiled with CFR 0.152.
 */
package won.utils.goals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.util.ResourceUtils;

public class GraphBlendingIterator
implements Iterator<Model> {
    private static int MAX_RESOURCE_PAIR_SIZE = 10;
    private Model dataGraph1 = ModelFactory.createDefaultModel();
    private Model dataGraph2;
    private String variableUriPrefix;
    private String blendingUriPrefix;
    private ArrayList<Pair<String, String>> blendingResourceUriPairs;
    private int powerSetIndex = 0;

    public GraphBlendingIterator(Model dataModel1, Model dataModel2, String variableUriPrefix, String blendingUriPrefix) {
        this.dataGraph1.add(dataModel1);
        this.dataGraph2 = ModelFactory.createDefaultModel();
        this.dataGraph2.add(dataModel2);
        this.variableUriPrefix = variableUriPrefix;
        this.blendingUriPrefix = blendingUriPrefix;
        this.blendingResourceUriPairs = new ArrayList();
        for (Statement stmt1 : dataModel1.listStatements().toList()) {
            if (!this.isVariableResource(stmt1.getSubject().getURI())) continue;
            for (Statement stmt2 : dataModel2.listStatements().toList()) {
                Pair blendingPair;
                if (!this.isVariableResource(stmt2.getSubject().getURI()) || !this.isValidBlending(stmt1, stmt2) || this.blendingResourceUriPairs.contains(blendingPair = Pair.of((Object)stmt1.getSubject().getURI(), (Object)stmt2.getSubject().getURI()))) continue;
                this.blendingResourceUriPairs.add((Pair<String, String>)blendingPair);
            }
        }
        if (this.blendingResourceUriPairs.size() > MAX_RESOURCE_PAIR_SIZE) {
            throw new IllegalArgumentException("too many blending possibilities for these input models");
        }
    }

    private boolean isVariableResource(String uri) {
        return uri != null && uri.startsWith(this.variableUriPrefix);
    }

    private boolean isValidBlending(Statement stmt1, Statement stmt2) {
        return stmt1.getObject().equals(stmt2.getObject()) && stmt1.getPredicate().equals(stmt2.getPredicate());
    }

    protected int getPowerSetSize() {
        return 1 << this.blendingResourceUriPairs.size();
    }

    private int getNextValidPowerSetIndex() {
        boolean isValidPowerSet;
        int validPowerSetIndex = this.powerSetIndex - 1;
        block0: do {
            ++validPowerSetIndex;
            isValidPowerSet = true;
            HashSet<Object> resourceSet = new HashSet<Object>();
            for (int i = 0; i < this.blendingResourceUriPairs.size(); ++i) {
                if ((validPowerSetIndex & 1 << i) <= 0) continue;
                Pair<String, String> currentPair = this.blendingResourceUriPairs.get(i);
                if (resourceSet.contains(currentPair.getLeft()) || resourceSet.contains(currentPair.getRight()) || ((String)currentPair.getLeft()).equals(currentPair.getRight())) {
                    isValidPowerSet = false;
                    continue block0;
                }
                resourceSet.add(currentPair.getLeft());
                resourceSet.add(currentPair.getRight());
            }
        } while (validPowerSetIndex < this.getPowerSetSize() && !isValidPowerSet);
        if (isValidPowerSet) {
            return validPowerSetIndex;
        }
        return this.getPowerSetSize();
    }

    @Override
    public boolean hasNext() {
        return this.powerSetIndex < this.getPowerSetSize();
    }

    @Override
    public Model next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        Model blendedModel = ModelFactory.createDefaultModel();
        blendedModel.setNsPrefixes(this.dataGraph1.getNsPrefixMap());
        blendedModel.setNsPrefixes(this.dataGraph2.getNsPrefixMap());
        blendedModel.add(this.dataGraph1.listStatements());
        blendedModel.add(this.dataGraph2.listStatements());
        int blendingIndex = 0;
        for (int i = 0; i < this.blendingResourceUriPairs.size(); ++i) {
            String blendedResourceUri;
            if ((this.powerSetIndex & 1 << i) <= 0) continue;
            while (blendedModel.containsResource((RDFNode)new ResourceImpl(blendedResourceUri = this.blendingUriPrefix + ++blendingIndex))) {
            }
            Pair<String, String> blendingPair = this.blendingResourceUriPairs.get(i);
            ResourceUtils.renameResource((Resource)blendedModel.getResource((String)blendingPair.getLeft()), (String)blendedResourceUri);
            ResourceUtils.renameResource((Resource)blendedModel.getResource((String)blendingPair.getRight()), (String)blendedResourceUri);
        }
        ++this.powerSetIndex;
        this.powerSetIndex = this.getNextValidPowerSetIndex();
        return blendedModel;
    }
}

