/*
 * Decompiled with CFR 0.152.
 */
package won.utils.goals;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.NotFoundException;
import org.topbraid.shacl.validation.ValidationUtil;
import won.utils.shacl.ShaclReportWrapper;

public class GoalUtils {
    private static final String goalExtractionQuery = GoalUtils.loadSparqlQuery("/won/utils/goals/extraction/goal-extraction-only-referenced-properties.rq");

    private static String loadSparqlQuery(String filePath) {
        InputStream is = GoalUtils.class.getResourceAsStream(filePath);
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)is, (Writer)writer, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new NotFoundException("failed to load resource: " + filePath);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return writer.toString();
    }

    public static Model extractGoalData(Model dataModel, Model shaclShapesModel) {
        Resource report = ValidationUtil.validateModel((Model)dataModel, (Model)shaclShapesModel, (boolean)false);
        Model combinedModel = ModelFactory.createDefaultModel();
        combinedModel.add(dataModel);
        combinedModel.add(report.getModel());
        combinedModel.add(shaclShapesModel);
        Query query = QueryFactory.create((String)goalExtractionQuery);
        try (QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)combinedModel);){
            Model result;
            Model model = result = qexec.execConstruct();
            return model;
        }
    }

    public static Boolean validateModelShaclConformity(Model dataModel, Model shaclShapesModel) {
        Resource report = ValidationUtil.validateModel((Model)dataModel, (Model)shaclShapesModel, (boolean)false);
        ShaclReportWrapper shaclReportWrapper = new ShaclReportWrapper(report);
        return shaclReportWrapper.isConform();
    }
}

