/*
 * Decompiled with CFR 0.152.
 */
package won.utils.goals;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.validation.ValidationUtil;
import won.utils.shacl.ShaclReportWrapper;

public class GoalInstantiationResult {
    private Model instanceModel;
    private ShaclReportWrapper shaclReportWrapper;
    private Model shaclShapesModel;

    public GoalInstantiationResult(Model instanceModel, Model shaclShapesModel) {
        this.instanceModel = instanceModel;
        this.shaclShapesModel = shaclShapesModel;
        Resource report = ValidationUtil.validateModel((Model)instanceModel, (Model)shaclShapesModel, (boolean)false);
        this.shaclReportWrapper = new ShaclReportWrapper(report);
    }

    public boolean isConform() {
        return this.shaclReportWrapper.isConform();
    }

    public Model getInstanceModel() {
        return this.instanceModel;
    }

    public ShaclReportWrapper getShaclReportWrapper() {
        return this.shaclReportWrapper;
    }

    public Model getShaclShapesModel() {
        return this.shaclShapesModel;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        this.instanceModel.write((Writer)writer, "TRIG");
        writer.write("\n");
        this.shaclReportWrapper.getReport().getModel().write((Writer)writer, "TRIG");
        return writer.toString();
    }
}

