/*
 * Decompiled with CFR 0.152.
 */
package won.utils.goals;

import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.update.UpdateExecutionFactory;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;
import org.topbraid.shacl.validation.ValidationUtil;
import won.protocol.model.AtomGraphType;
import won.protocol.util.AtomModelWrapper;
import won.protocol.util.RdfUtils;
import won.utils.goals.GoalInstantiationResult;
import won.utils.goals.GoalUtils;
import won.utils.goals.GraphBlendingIterator;
import won.utils.shacl.ShaclReportWrapper;

public class GoalInstantiationProducer {
    private Dataset atom1;
    private Dataset atom2;
    private Model combinedModelWithoutGoals;
    private String variableUriPrefix;
    private String blendingUriPrefix;

    public GoalInstantiationProducer(Dataset atom1, Dataset atom2, Dataset conversation, String variableUriPrefix, String blendingUriPrefix) {
        this.atom1 = atom1;
        this.atom2 = atom2;
        this.variableUriPrefix = variableUriPrefix;
        this.blendingUriPrefix = blendingUriPrefix;
        Model strippedAtom1 = this.getAtomContentModelWithoutGoals(atom1);
        Model strippedAtom2 = this.getAtomContentModelWithoutGoals(atom2);
        Dataset combinedDataset = DatasetFactory.create();
        combinedDataset.addNamedModel("atom1", strippedAtom1);
        combinedDataset.addNamedModel("atom2", strippedAtom2);
        if (conversation != null) {
            String sparqlQuery = "PREFIX msg: <https://w3id.org/won/message#> \nDELETE { \n    GRAPH ?g {?s ?p ?o} \n} \nWHERE { \n    GRAPH ?g { ?s ?p ?o } \n    { SELECT (GROUP_CONCAT(?content; separator=\" \") as ?contentGraphs) \n            WHERE { GRAPH <urn:x-arq:UnionGraph> { ?msg msg:content ?content } \n    }\n} \nFILTER (!contains(?contentGraphs,str(?g))) \n} \n";
            UpdateRequest update = UpdateFactory.create((String)sparqlQuery);
            UpdateProcessor updateProcessor = UpdateExecutionFactory.create((UpdateRequest)update, (Dataset)conversation);
            updateProcessor.execute();
            RdfUtils.addDatasetToDataset((Dataset)combinedDataset, (Dataset)conversation, (boolean)false);
        }
        this.combinedModelWithoutGoals = RdfUtils.mergeAllDataToSingleModel((Dataset)combinedDataset);
    }

    private Model getAtomContentModelWithoutGoals(Dataset atom) {
        AtomModelWrapper atomWrapper = new AtomModelWrapper(atom);
        Model atom1Model = atomWrapper.copyAtomModel(AtomGraphType.ATOM);
        for (Resource goal : atomWrapper.getGoals()) {
            RdfUtils.removeResource((Model)atom1Model, (Resource)goal);
        }
        return atom1Model;
    }

    private GoalInstantiationResult findInstantiationForGoals(Resource goal1, Resource goal2) {
        AtomModelWrapper atomWrapper1 = new AtomModelWrapper(this.atom1);
        Model shapesModel1 = atomWrapper1.getShapesGraph(goal1);
        Model dataModel1 = atomWrapper1.getDataGraph(goal1);
        AtomModelWrapper atomWrapper2 = new AtomModelWrapper(this.atom2);
        Model shapesModel2 = atomWrapper2.getShapesGraph(goal2);
        Model dataModel2 = atomWrapper2.getDataGraph(goal2);
        if (shapesModel1 == null || shapesModel2 == null) {
            throw new IllegalArgumentException("shapes model for goal not found");
        }
        Model combinedModelWithGoalData = ModelFactory.createDefaultModel();
        combinedModelWithGoalData.add(this.combinedModelWithoutGoals);
        if (dataModel1 != null) {
            combinedModelWithGoalData.add(dataModel1);
        }
        if (dataModel2 != null) {
            combinedModelWithGoalData.add(dataModel2);
        }
        Model extractedModel1 = GoalUtils.extractGoalData(combinedModelWithGoalData, shapesModel1);
        Model extractedModel2 = GoalUtils.extractGoalData(combinedModelWithGoalData, shapesModel2);
        Model combinedShapesModel = ModelFactory.createDefaultModel();
        combinedShapesModel.add(shapesModel1);
        combinedShapesModel.add(shapesModel2);
        int minValidationResults = Integer.MAX_VALUE;
        GoalInstantiationResult bestGoalInstantiationResult = null;
        GraphBlendingIterator blendingIterator = new GraphBlendingIterator(extractedModel1, extractedModel2, this.variableUriPrefix, this.blendingUriPrefix);
        while (blendingIterator.hasNext()) {
            Model blendedModel = blendingIterator.next();
            Resource report = ValidationUtil.validateModel((Model)blendedModel, (Model)combinedShapesModel, (boolean)false);
            ShaclReportWrapper shaclReportWrapper = new ShaclReportWrapper(report);
            if (shaclReportWrapper.isConform()) {
                Function<Model, Boolean> modelTestingFunction = param -> GoalUtils.validateModelShaclConformity(param, combinedShapesModel);
                Model condensedModel = RdfUtils.condenseModelByIterativeTesting((Model)blendedModel, modelTestingFunction);
                bestGoalInstantiationResult = new GoalInstantiationResult(condensedModel, combinedShapesModel);
                continue;
            }
            if (shaclReportWrapper.getValidationResults().size() >= minValidationResults) continue;
            minValidationResults = shaclReportWrapper.getValidationResults().size();
            bestGoalInstantiationResult = new GoalInstantiationResult(blendedModel, combinedShapesModel);
        }
        return bestGoalInstantiationResult;
    }

    public GoalInstantiationResult findInstantiationForGoal(Resource goal) {
        AtomModelWrapper atomWrapper1 = new AtomModelWrapper(this.atom1);
        AtomModelWrapper atomWrapper2 = new AtomModelWrapper(this.atom2);
        Model goalShapesModel = null;
        Model goalDataModel = null;
        if (atomWrapper1.getGoals().contains(goal) && !atomWrapper2.getGoals().contains(goal)) {
            goalShapesModel = atomWrapper1.getShapesGraph(goal);
            goalDataModel = atomWrapper1.getDataGraph(goal);
        } else if (atomWrapper2.getGoals().contains(goal) && !atomWrapper1.getGoals().contains(goal)) {
            goalShapesModel = atomWrapper2.getShapesGraph(goal);
            goalDataModel = atomWrapper2.getDataGraph(goal);
        } else {
            throw new IllegalArgumentException("problem to identify goal resource in one of the two atom models");
        }
        if (goalShapesModel == null) {
            throw new IllegalArgumentException("shapes model for goal not found");
        }
        Model combinedModelWithGoalData = ModelFactory.createDefaultModel();
        combinedModelWithGoalData.add(this.combinedModelWithoutGoals);
        if (goalDataModel != null) {
            combinedModelWithGoalData.add(goalDataModel);
        }
        Model extractedModel = GoalUtils.extractGoalData(combinedModelWithGoalData, goalShapesModel);
        return new GoalInstantiationResult(extractedModel, goalShapesModel);
    }

    public static GoalInstantiationResult findInstantiationForGoalInDataset(Dataset atom, Resource goal, Model model) {
        AtomModelWrapper atomWrapper = new AtomModelWrapper(atom);
        if (!atomWrapper.getGoals().contains(goal)) {
            throw new IllegalArgumentException("problem to identify goal resource in the atom model");
        }
        Model goalShapesModel = atomWrapper.getShapesGraph(goal);
        if (goalShapesModel == null) {
            throw new IllegalArgumentException("shapes model for goal not found");
        }
        Model extractedModel = GoalUtils.extractGoalData(model, goalShapesModel);
        return new GoalInstantiationResult(extractedModel, goalShapesModel);
    }

    public Collection<GoalInstantiationResult> createAllGoalCombinationInstantiationResults() {
        AtomModelWrapper atomWrapper1 = new AtomModelWrapper(this.atom1);
        AtomModelWrapper atomWrapper2 = new AtomModelWrapper(this.atom2);
        LinkedList<GoalInstantiationResult> results = new LinkedList<GoalInstantiationResult>();
        for (Resource goal1 : atomWrapper1.getGoals()) {
            for (Resource goal2 : atomWrapper2.getGoals()) {
                GoalInstantiationResult instantiationResult = this.findInstantiationForGoals(goal1, goal2);
                results.add(instantiationResult);
            }
        }
        return results;
    }

    public Collection<GoalInstantiationResult> createAllGoalInstantiationResults() {
        AtomModelWrapper atomWrapper1 = new AtomModelWrapper(this.atom1);
        AtomModelWrapper atomWrapper2 = new AtomModelWrapper(this.atom2);
        LinkedList<GoalInstantiationResult> results = new LinkedList<GoalInstantiationResult>();
        boolean addedGoal2s = false;
        for (Resource goal1 : atomWrapper1.getGoals()) {
            results.add(this.findInstantiationForGoal(goal1));
            for (Resource goal2 : atomWrapper2.getGoals()) {
                GoalInstantiationResult instantiationResult = this.findInstantiationForGoals(goal1, goal2);
                results.add(instantiationResult);
                if (addedGoal2s) continue;
                results.add(this.findInstantiationForGoal(goal2));
            }
            addedGoal2s = true;
        }
        if (!addedGoal2s) {
            for (Resource goal2 : atomWrapper2.getGoals()) {
                results.add(this.findInstantiationForGoal(goal2));
            }
        }
        return results;
    }

    public Collection<GoalInstantiationResult> createGoalInstantiationResultsForAtom1() {
        return this.createGoalInstantiationResults(this.atom1);
    }

    public Collection<GoalInstantiationResult> createGoalInstantiationResultsForAtom2() {
        return this.createGoalInstantiationResults(this.atom2);
    }

    private Collection<GoalInstantiationResult> createGoalInstantiationResults(Dataset atom) {
        AtomModelWrapper atomWrapper = new AtomModelWrapper(atom);
        LinkedList<GoalInstantiationResult> results = new LinkedList<GoalInstantiationResult>();
        for (Resource goal : atomWrapper.getGoals()) {
            results.add(this.findInstantiationForGoal(goal));
        }
        return results;
    }
}

