/*
 * Decompiled with CFR 0.152.
 */
package won.utils.shacl;

import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.vocabulary.SH;

public class ValidationResultWrapper {
    private Resource validationResult;

    public ValidationResultWrapper(Resource validationResult) {
        this.validationResult = validationResult;
        if (!validationResult.getPropertyResourceValue(RDF.type).equals((Object)SH.ValidationResult)) {
            throw new IllegalArgumentException("Resource is not of type " + SH.ValidationResult.toString());
        }
    }

    public Resource getFocusNode() {
        return this.validationResult.getPropertyResourceValue(SH.focusNode);
    }

    public Resource getResultSeverity() {
        return this.validationResult.getPropertyResourceValue(SH.resultSeverity);
    }

    public Resource getSourceConstraintComponent() {
        return this.validationResult.getPropertyResourceValue(SH.sourceConstraintComponent);
    }

    public Resource getResultPath() {
        return this.validationResult.getPropertyResourceValue(SH.resultPath);
    }

    public String getResultMessage() {
        StmtIterator stmtIterator = this.validationResult.listProperties(SH.resultMessage);
        return stmtIterator.hasNext() ? stmtIterator.nextStatement().getString() : null;
    }

    public Resource getValue() {
        return this.validationResult.getPropertyResourceValue(SH.value);
    }

    public Resource getSourceShape() {
        return this.validationResult.getPropertyResourceValue(SH.sourceShape);
    }

    public Resource getDetail() {
        return this.validationResult.getPropertyResourceValue(SH.detail);
    }
}

