/*
 * Decompiled with CFR 0.152.
 */
package won.utils.shacl;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.shacl.vocabulary.SH;
import won.protocol.util.RdfUtils;
import won.utils.shacl.ValidationResultWrapper;

public class ShaclReportWrapper {
    private Resource report;
    private Resource reportResource;

    public ShaclReportWrapper(Resource report) {
        this.report = report;
        this.reportResource = RdfUtils.findOneSubjectResource((Model)report.getModel(), (Property)RDF.type, (RDFNode)SH.ValidationReport);
    }

    public Resource getReport() {
        return this.report;
    }

    public boolean isConform() {
        RDFNode node = RdfUtils.findOnePropertyFromResource((Model)this.report.getModel(), (Resource)this.reportResource, (Property)SH.conforms);
        if (node != null && node.asLiteral() != null) {
            return node.asLiteral().getBoolean();
        }
        return false;
    }

    public Collection<ValidationResultWrapper> getValidationResults() {
        LinkedList<ValidationResultWrapper> validationResults = new LinkedList<ValidationResultWrapper>();
        for (Statement statement : this.reportResource.listProperties(SH.result).toList()) {
            if (!statement.getResource().getPropertyResourceValue(RDF.type).equals((Object)SH.ValidationResult)) continue;
            validationResults.add(new ValidationResultWrapper(statement.getResource()));
        }
        return validationResults;
    }
}

