/*
 * Decompiled with CFR 0.152.
 */
package won.utils.crawl.app;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.tdb.TDB;
import org.apache.jena.update.GraphStore;
import org.apache.jena.update.GraphStoreFactory;
import org.apache.jena.update.UpdateAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;
import won.protocol.util.RdfUtils;
import won.protocol.util.linkeddata.CachingLinkedDataSource;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.vocabulary.WON;

@Component
public class CLRunnerBean
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(CLRunnerBean.class);
    private LinkedDataSource linkedDataSource;

    public void run(String ... args) throws Exception {
        if (args == null && args.length == 0) {
            logger.warn("arguments: [space-separated list of uris to crawl]");
            return;
        }
        Dataset needDataset = CachingLinkedDataSource.makeDataset();
        for (String arg : args) {
            URI uri = URI.create(arg);
            logger.info("Getting Data from uri: " + uri);
            RdfUtils.addDatasetToDataset((Dataset)needDataset, (Dataset)this.linkedDataSource.getDataForResourceWithPropertyPath(uri, CLRunnerBean.configurePropertyPaths(), 10000, 5, false), (boolean)true);
        }
        logger.info("PRINTING DATASET");
        RDFDataMgr.write((OutputStream)System.out, (Dataset)needDataset, (Lang)Lang.TRIG);
        logger.info("PRINTED DATASET");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            ResultSet results;
            QueryExecution qExec;
            QuerySolutionMap initialBinding;
            System.out.print("ENTER SPARQL-QUERY> ");
            String line = br.readLine();
            if ("exit".equals(line)) break;
            if ("help".equals(line)) {
                this.printHelp();
                continue;
            }
            if (line.startsWith("%listgraphs")) {
                try {
                    Query query = QueryFactory.create((String)"PREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#>PREFIX geo:   <http://www.w3.org/2003/01/geo/wgs84_pos#>PREFIX xsd:   <http://www.w3.org/2001/XMLSchema#>PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX won:   <http://purl.org/webofneeds/model#>PREFIX gr:    <http://purl.org/goodrelations/v1#>PREFIX sioc:  <http://rdfs.org/sioc/ns#>PREFIX ldp:   <http://www.w3.org/ns/ldp#>PREFIX dc:    <http://purl.org/dc/elements/1.1/>PREFIX msg:   <http://purl.org/webofneeds/message#>SELECT DISTINCT ?g WHERE {graph ?g {?s ?p ?o }.}");
                    initialBinding = new QuerySolutionMap();
                    qExec = QueryExecutionFactory.create((Query)query, (Dataset)needDataset, (QuerySolution)initialBinding);
                    qExec.getContext().set(TDB.symUnionDefaultGraph, true);
                    results = qExec.execSelect();
                    this.printResults(results);
                    qExec.close();
                }
                catch (QueryParseException e) {
                    System.out.println("INVALID SPARQL-QUERY: " + e.getMessage());
                    this.printHelp();
                }
                continue;
            }
            if (line.startsWith("%listall")) {
                try {
                    Query query = QueryFactory.create((String)"PREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#>PREFIX geo:   <http://www.w3.org/2003/01/geo/wgs84_pos#>PREFIX xsd:   <http://www.w3.org/2001/XMLSchema#>PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX won:   <http://purl.org/webofneeds/model#>PREFIX gr:    <http://purl.org/goodrelations/v1#>PREFIX sioc:  <http://rdfs.org/sioc/ns#>PREFIX ldp:   <http://www.w3.org/ns/ldp#>PREFIX dc:    <http://purl.org/dc/elements/1.1/>PREFIX msg:   <http://purl.org/webofneeds/message#>SELECT * WHERE { ?need won:hasContent ?x; won:isInState ?state. ?x   dc:description ?desc; won:hasTag ?tag; dc:title ?title. ?x won:hasContentDescription ?y. OPTIONAL {?y won:hasLocationSpecification ?loc. ?loc won:hasAddress ?address; geo:latitude ?lat; geo:longitude ?lng.} OPTIONAL {?y won:hasTimespecification ?time. ?time won:hasEndTime ?endtime; won:hasStartTime ?starttime; won:hasRecurInfiniteTimes ?recinf; won:hasRecursIn ?recin.}}");
                    initialBinding = new QuerySolutionMap();
                    qExec = QueryExecutionFactory.create((Query)query, (Dataset)needDataset, (QuerySolution)initialBinding);
                    qExec.getContext().set(TDB.symUnionDefaultGraph, true);
                    results = qExec.execSelect();
                    this.printResults(results);
                    qExec.close();
                }
                catch (QueryParseException e) {
                    System.out.println("INVALID SPARQL-QUERY: " + e.getMessage());
                    this.printHelp();
                }
                continue;
            }
            if (line.startsWith("#")) {
                try {
                    String updateString = "PREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#>PREFIX geo:   <http://www.w3.org/2003/01/geo/wgs84_pos#>PREFIX xsd:   <http://www.w3.org/2001/XMLSchema#>PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX won:   <http://purl.org/webofneeds/model#>PREFIX gr:    <http://purl.org/goodrelations/v1#>PREFIX sioc:  <http://rdfs.org/sioc/ns#>PREFIX ldp:   <http://www.w3.org/ns/ldp#>PREFIX dc:    <http://purl.org/dc/elements/1.1/>PREFIX msg:   <http://purl.org/webofneeds/message#>" + line.substring(1);
                    GraphStore graphStore = GraphStoreFactory.create((Dataset)needDataset);
                    UpdateAction.parseExecute((String)updateString, (DatasetGraph)graphStore);
                }
                catch (QueryParseException e) {
                    e.printStackTrace();
                    System.out.println("INVALID SPARQL-QUERY: " + e.getMessage());
                    this.printHelp();
                }
                continue;
            }
            String queryString = "PREFIX rdfs:  <http://www.w3.org/2000/01/rdf-schema#>PREFIX geo:   <http://www.w3.org/2003/01/geo/wgs84_pos#>PREFIX xsd:   <http://www.w3.org/2001/XMLSchema#>PREFIX rdf:   <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX won:   <http://purl.org/webofneeds/model#>PREFIX gr:    <http://purl.org/goodrelations/v1#>PREFIX sioc:  <http://rdfs.org/sioc/ns#>PREFIX ldp:   <http://www.w3.org/ns/ldp#>PREFIX dc:    <http://purl.org/dc/elements/1.1/>PREFIX msg:   <http://purl.org/webofneeds/message#>" + line;
            try {
                Query query = QueryFactory.create((String)queryString);
                QuerySolutionMap initialBinding2 = new QuerySolutionMap();
                QueryExecution qExec2 = QueryExecutionFactory.create((Query)query, (Dataset)needDataset, (QuerySolution)initialBinding2);
                qExec2.getContext().set(TDB.symUnionDefaultGraph, true);
                ResultSet results2 = qExec2.execSelect();
                this.printResults(results2);
                qExec2.close();
            }
            catch (QueryParseException e) {
                System.out.println("INVALID SPARQL-QUERY: " + e.getMessage());
                this.printHelp();
            }
        }
    }

    private void printResults(ResultSet results) {
        System.out.println("---------------------------RESULTS-----------------------------------");
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            StringBuilder sb = new StringBuilder();
            Iterator it = soln.varNames();
            while (it.hasNext()) {
                String var = (String)it.next();
                sb.append(var).append(": ").append(soln.get(var)).append(" ");
            }
            System.out.println(sb.toString());
        }
        System.out.println("---------------------------------------------------------------------");
    }

    private void printHelp() {
        System.out.println("Enter SPARQL Query (Prefix not needed), or type \"exit\" to exit");
        System.out.println("List all loaded Graphs: \"SELECT DISTINCT ?g WHERE {graph ?g {?s ?p ?o }.}\"");
        System.out.println("Commands > [QUERY]     - executes the given query");
        System.out.println("Commands > #[STMT]     - executes the given statement");
        System.out.println("Commands > %listall    - lists all needs");
        System.out.println("Commands > %listgraphs - lists all graphs");
    }

    private static List<Path> configurePropertyPaths() {
        ArrayList<Path> propertyPaths = new ArrayList<Path>();
        CLRunnerBean.addPropertyPath(propertyPaths, "<" + WON.HAS_CONNECTIONS + ">");
        CLRunnerBean.addPropertyPath(propertyPaths, "<" + WON.HAS_CONNECTIONS + ">/rdfs:member");
        CLRunnerBean.addPropertyPath(propertyPaths, "<" + WON.HAS_CONNECTIONS + ">/rdfs:member/<" + WON.HAS_REMOTE_CONNECTION + ">");
        CLRunnerBean.addPropertyPath(propertyPaths, "<" + WON.HAS_CONNECTIONS + ">/rdfs:member/<" + WON.HAS_EVENT_CONTAINER + ">/rdfs:member");
        CLRunnerBean.addPropertyPath(propertyPaths, "<" + WON.HAS_CONNECTIONS + ">/rdfs:member/<" + WON.HAS_REMOTE_CONNECTION + ">/<" + WON.BELONGS_TO_NEED + ">");
        return propertyPaths;
    }

    private static List<Path> configurePropertyPathAll() {
        ArrayList<Path> propertyPaths = new ArrayList<Path>();
        CLRunnerBean.addPropertyPath(propertyPaths, "rdfs:member");
        CLRunnerBean.addPropertyPath(propertyPaths, "rdfs:member/<" + WON.HAS_CONNECTIONS + ">");
        CLRunnerBean.addPropertyPath(propertyPaths, "rdfs:member/<" + WON.HAS_CONNECTIONS + ">/rdfs:member");
        CLRunnerBean.addPropertyPath(propertyPaths, "rdfs:member/<" + WON.HAS_CONNECTIONS + ">/rdfs:member/<" + WON.HAS_REMOTE_CONNECTION + ">");
        CLRunnerBean.addPropertyPath(propertyPaths, "rdfs:member/<" + WON.HAS_CONNECTIONS + ">/rdfs:member/<" + WON.HAS_EVENT_CONTAINER + ">/rdfs:member");
        CLRunnerBean.addPropertyPath(propertyPaths, "rdfs:member/<" + WON.HAS_CONNECTIONS + ">/rdfs:member/<" + WON.HAS_REMOTE_CONNECTION + ">/<" + WON.BELONGS_TO_NEED + ">");
        return propertyPaths;
    }

    private static void addPropertyPath(List<Path> propertyPaths, String pathString) {
        Path path = PathParser.parse((String)pathString, (PrefixMapping)PrefixMapping.Standard);
        propertyPaths.add(path);
    }

    @Autowired
    public void setLinkedDataSource(LinkedDataSource linkedDataSource) {
        this.linkedDataSource = linkedDataSource;
    }
}

