/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.agreement.AgreementProtocolState;
import won.protocol.agreement.IncompleteConversationDataException;
import won.protocol.rest.LinkedDataFetchingException;
import won.protocol.util.linkeddata.CachingLinkedDataSource;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

public class WonConversationUtils {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private static <T> T getFirstOrNull(Dataset dataset, Function<Dataset, List<T>> function) {
        List<T> results = function.apply(dataset);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public static URI getNthLatestMessage(Dataset conversationDataset, Predicate predicate, int n) {
        return AgreementProtocolState.of(conversationDataset).getNthLatestMessage(predicate, n);
    }

    public static URI getLatestMessageOfAtom(Dataset conversationDataset, URI senderAtom) {
        return AgreementProtocolState.of(conversationDataset).getLatestMessageSentByAtom(senderAtom);
    }

    public static URI getNthLatestMessageOfAtom(Dataset conversationDataset, URI senderAtom, int n) {
        return AgreementProtocolState.of(conversationDataset).getNthLatestMessageSentByAtom(senderAtom, n);
    }

    public static URI getLatestAcceptsMessageOfAtom(Dataset conversationDataset, URI senderAtom) {
        return AgreementProtocolState.of(conversationDataset).getLatestAcceptsMessageSentByAtom(senderAtom);
    }

    public static URI getLatestAcceptsMessage(Dataset conversationDataset) {
        return AgreementProtocolState.of(conversationDataset).getLatestAcceptsMessage();
    }

    public static URI getLatestRetractsMessageOfAtom(Dataset conversationDataset, URI senderAtom) {
        return AgreementProtocolState.of(conversationDataset).getLatestRetractsMessageSentByAtom(senderAtom);
    }

    public static URI getLatestProposesMessageOfAtom(Dataset conversationDataset, URI senderAtom) {
        return AgreementProtocolState.of(conversationDataset).getLatestProposesMessageSentByAtom(senderAtom);
    }

    public static URI getLatestProposesToCancelMessageOfAtom(Dataset conversationDataset, URI senderAtom) {
        return AgreementProtocolState.of(conversationDataset).getLatestProposesToCancelMessageSentByAtom(senderAtom);
    }

    public static URI getLatestRejectsMessageOfAtom(Dataset conversationDataset, URI senderAtom, int n) {
        return AgreementProtocolState.of(conversationDataset).getLatestRejectsMessageSentByAtom(senderAtom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgreementProtocolState getAgreementProtocolState(URI connectionUri, LinkedDataSource linkedDataSource) {
        URI atomUri = WonLinkedDataUtils.getAtomURIforConnectionURI((URI)connectionUri, (LinkedDataSource)linkedDataSource);
        HashSet<URI> recrawledForIncompleteness = new HashSet<URI>();
        HashSet<URI> recrawledForFailedFetch = new HashSet<URI>();
        while (true) {
            try {
                Dataset conversationDataset = WonLinkedDataUtils.getConversationAndAtomsDataset((URI)connectionUri, (LinkedDataSource)linkedDataSource);
                return AgreementProtocolState.of(conversationDataset);
            }
            catch (IncompleteConversationDataException e) {
                WonConversationUtils.refreshDataForConnection(connectionUri, atomUri, linkedDataSource);
                if (WonConversationUtils.recrawl(recrawledForIncompleteness, connectionUri, atomUri, linkedDataSource, e.getMissingMessageUri(), e.getReferringMessageUri())) continue;
                throw e;
            }
            catch (LinkedDataFetchingException e) {
                WonConversationUtils.refreshDataForConnection(connectionUri, atomUri, linkedDataSource);
                if (!WonConversationUtils.recrawl(recrawledForFailedFetch, connectionUri, atomUri, linkedDataSource, e.getResourceUri())) throw e;
                continue;
            }
            break;
        }
    }

    private static void refreshDataForConnection(URI connectionUri, URI atomUri, LinkedDataSource linkedDataSource) {
        if (!(linkedDataSource instanceof CachingLinkedDataSource)) {
            return;
        }
        if (connectionUri == null) {
            return;
        }
        WonConversationUtils.invalidate(connectionUri, atomUri, linkedDataSource);
        URI connectionMessageContainerUri = WonLinkedDataUtils.getMessageContainerURIforConnectionURI((URI)connectionUri, (LinkedDataSource)linkedDataSource);
        WonConversationUtils.invalidate(connectionMessageContainerUri, atomUri, linkedDataSource);
        URI targetConnectionUri = WonLinkedDataUtils.getTargetConnectionURIforConnectionURI((URI)connectionUri, (LinkedDataSource)linkedDataSource);
        if (targetConnectionUri == null) {
            return;
        }
        WonConversationUtils.invalidate(targetConnectionUri, atomUri, linkedDataSource);
        URI targetConnectionMessageContainerUri = WonLinkedDataUtils.getMessageContainerURIforConnectionURI((URI)targetConnectionUri, (LinkedDataSource)linkedDataSource);
        WonConversationUtils.invalidate(targetConnectionMessageContainerUri, atomUri, linkedDataSource);
    }

    private static boolean recrawl(Set<URI> recrawled, URI connectionUri, URI atomUri, LinkedDataSource linkedDataSource, URI ... uris) {
        HashSet urisToCrawl = new HashSet();
        Arrays.stream(uris).filter(x -> !recrawled.contains(x)).forEach(urisToCrawl::add);
        if (urisToCrawl.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("connection {}: not recrawling again: {}", (Object)connectionUri, (Object)Arrays.toString(uris));
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("connection {}, recrawling: {}", (Object)connectionUri, urisToCrawl);
        }
        if (linkedDataSource instanceof CachingLinkedDataSource) {
            urisToCrawl.stream().forEach(uri -> WonConversationUtils.invalidate(uri, atomUri, linkedDataSource));
        }
        recrawled.addAll(urisToCrawl);
        return true;
    }

    private static void invalidate(URI uri, URI webId, LinkedDataSource linkedDataSource) {
        if (!(linkedDataSource instanceof CachingLinkedDataSource)) {
            return;
        }
        if (uri != null) {
            ((CachingLinkedDataSource)linkedDataSource).invalidate(uri);
            if (webId != null) {
                ((CachingLinkedDataSource)linkedDataSource).invalidate(uri, webId);
            }
        }
    }
}

