/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement.petrinet;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.imperial.pipe.models.petrinet.PetriNet;
import won.protocol.agreement.AgreementProtocolState;
import won.protocol.agreement.petrinet.PetriNetLoader;
import won.protocol.agreement.petrinet.PetriNetState;
import won.protocol.agreement.petrinet.PetriNetUris;
import won.protocol.vocabulary.WONWF;

public class PetriNetStates {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private AgreementProtocolState agreementProtocolState;
    private Dataset conversation;
    private Map<URI, PetriNetState> petrinetStates = new HashMap<URI, PetriNetState>();
    private PetriNetLoader petriNetLoader = new PetriNetLoader();

    public static PetriNetStates of(Dataset conversation) {
        return new PetriNetStates(conversation);
    }

    public static PetriNetStates of(AgreementProtocolState agreementProtocolState) {
        return new PetriNetStates(agreementProtocolState);
    }

    private PetriNetStates(Dataset conversation) {
        this.conversation = conversation;
        this.agreementProtocolState = AgreementProtocolState.of(conversation);
        this.calculate();
    }

    private PetriNetStates(AgreementProtocolState agreementProtocolState) {
        this.agreementProtocolState = agreementProtocolState;
        this.conversation = agreementProtocolState.getConversationDataset();
        this.calculate();
    }

    private void calculate() {
        List<URI> uris = this.agreementProtocolState.getAgreementsAndClaimsInChronologicalOrder(true);
        uris.forEach(uri -> {
            boolean isAgreement = this.agreementProtocolState.isAgreement((URI)uri);
            if (!isAgreement && !this.agreementProtocolState.isClaim((URI)uri)) {
                throw new IllegalStateException(uri + " was reported as agreement or claim but is neither");
            }
            Model agreementOrClaim = isAgreement ? this.agreementProtocolState.getAgreement((URI)uri) : this.agreementProtocolState.getClaim((URI)uri);
            logger.info("processing petri net data in {} {}", (Object)(isAgreement ? "agreement" : "claim"), uri);
            this.loadPetrinetsForAgreement(agreementOrClaim, (URI)uri, isAgreement);
            this.executePetriNetEventsForAgreement(agreementOrClaim, (URI)uri, isAgreement);
        });
    }

    private void loadPetrinetsForAgreement(Model agreement, URI agreementUri, boolean isAgreement) {
        StmtIterator it = agreement.listStatements(null, WONWF.inlinePetriNetDefinition, (RDFNode)null);
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            if (!stmt.getSubject().isURIResource() || !stmt.getObject().isLiteral()) continue;
            URI petriNetUri = URI.create(stmt.getSubject().asResource().getURI());
            String base64EncodedPnml = stmt.getObject().asLiteral().getString();
            if (this.petrinetStates.containsKey(petriNetUri)) {
                logger.info("ignoring redefinition of petri net {} in {} {}", new Object[]{petriNetUri, isAgreement ? "agreement" : "claim", agreementUri});
                continue;
            }
            logger.info("found petri net definition {} in {} {}", new Object[]{petriNetUri, isAgreement ? "agreement" : "claim", agreementUri});
            PetriNet petriNet = this.petriNetLoader.readBase64EncodedPNML(base64EncodedPnml);
            PetriNetState state = new PetriNetState(petriNetUri, petriNet);
            this.petrinetStates.put(petriNetUri, state);
        }
    }

    private void executePetriNetEventsForAgreement(Model agreement, URI agreementUri, boolean isAgreement) {
        StmtIterator it = agreement.listStatements(null, WONWF.firesTransition, (RDFNode)null);
        while (it.hasNext()) {
            Statement stmt = (Statement)it.next();
            if (!stmt.getSubject().isURIResource() || !stmt.getObject().isURIResource()) continue;
            URI petriNetUri = URI.create(stmt.getSubject().asResource().getURI());
            URI eventURI = URI.create(stmt.getObject().asResource().getURI());
            PetriNetState state = this.petrinetStates.get(petriNetUri);
            if (state != null) {
                logger.info("firing transition {} on petri net {} because of data found in {} {}", new Object[]{eventURI, petriNetUri, isAgreement ? "agreement" : "claim", agreementUri});
                state.fireTransition(eventURI);
                continue;
            }
            logger.info("ignoring event {} for unknown petri net {} in {} {}", new Object[]{eventURI, petriNetUri, isAgreement ? "agreement" : "claim", agreementUri});
        }
    }

    public Collection<PetriNetState> getPetrinetStates() {
        return this.petrinetStates.values();
    }

    public Set<PetriNetUris> getPetriNetUris() {
        HashSet<PetriNetUris> petriNetUriSet = new HashSet<PetriNetUris>();
        this.petrinetStates.values().forEach(petriNetState -> {
            PetriNetUris petriNetUris = new PetriNetUris();
            petriNetUris.setEnabledTransitions(petriNetState.getEnabledTransitions());
            petriNetUris.setMarkedPlaces(petriNetState.getMarkedPlaces());
            petriNetUris.setPetriNetURI(petriNetState.getPetriNetURI());
            petriNetUriSet.add(petriNetUris);
        });
        return petriNetUriSet;
    }
}

