/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement.petrinet;

import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import uk.ac.imperial.pipe.animation.PetriNetAnimator;
import uk.ac.imperial.pipe.models.petrinet.PetriNet;

public class PetriNetState {
    private PetriNet petriNet;
    private PetriNetAnimator petriNetAnimator;
    private URI petriNetURI;

    public PetriNetState(URI petrinetURI, PetriNet petriNet) {
        this.petriNetURI = petrinetURI;
        this.petriNet = petriNet;
        this.petriNetAnimator = new PetriNetAnimator(petriNet);
    }

    public Set<URI> getMarkedPlaces() {
        return this.petriNet.getPlaces().stream().filter(place -> place.getNumberOfTokensStored() > 0).map(place -> URI.create(place.getId())).collect(Collectors.toSet());
    }

    public Set<URI> getEnabledTransitions() {
        return this.petriNetAnimator.getEnabledTransitions().stream().map(t -> URI.create(t.getId())).collect(Collectors.toSet());
    }

    public void fireTransition(URI transitionURI) {
        this.petriNetAnimator.getEnabledTransitions().stream().filter(t -> transitionURI.toString().equals(t.getId())).forEach(arg_0 -> ((PetriNetAnimator)this.petriNetAnimator).fireTransition(arg_0));
    }

    public Set<URI> getPlaces() {
        return this.petriNet.getPlaces().stream().map(p -> URI.create(p.getId())).collect(Collectors.toSet());
    }

    public Set<URI> getTransitions() {
        return this.petriNet.getTransitions().stream().map(p -> URI.create(p.getId())).collect(Collectors.toSet());
    }

    public URI getPetriNetURI() {
        return this.petriNetURI;
    }
}

