/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement.petrinet;

import java.io.File;
import java.io.FileWriter;
import java.util.Base64;
import java.util.Optional;
import uk.ac.imperial.pipe.io.PetriNetIO;
import uk.ac.imperial.pipe.io.PetriNetIOImpl;
import uk.ac.imperial.pipe.models.petrinet.PetriNet;

public class PetriNetLoader {
    private Optional<PetriNetIOImpl> petriNetIO = Optional.empty();

    private synchronized PetriNetIO getPetriNetIO() {
        if (this.petriNetIO.isPresent()) {
            return (PetriNetIO)this.petriNetIO.get();
        }
        try {
            this.petriNetIO = Optional.of(new PetriNetIOImpl());
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize PetriNetIO", e);
        }
        return (PetriNetIO)this.petriNetIO.get();
    }

    public PetriNet readBase64EncodedPNML(String base64EncodedPNML) {
        byte[] pnmlBytes = Base64.getDecoder().decode(base64EncodedPNML);
        String pnmlString = new String(pnmlBytes);
        return this.readPNML(pnmlString);
    }

    public PetriNet readPNML(String pnml) {
        PetriNetIO petriNetIO = this.getPetriNetIO();
        Optional<Object> tempfile = Optional.empty();
        try {
            tempfile = Optional.of(File.createTempFile("petrinet-tmp-", ".xml"));
            try (FileWriter fw = new FileWriter((File)tempfile.get());){
                fw.write(pnml);
            }
            fw = petriNetIO.read(((File)tempfile.get()).getAbsolutePath());
            return fw;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error reading petrinet from base64 String", e);
        }
        finally {
            if (tempfile.isPresent()) {
                ((File)tempfile.get()).delete();
            }
        }
    }
}

