/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.thrift.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.agreement.DeliveryChain;
import won.protocol.agreement.effect.MessageEffect;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;

public class ConversationMessage
implements Comparable<ConversationMessage> {
    private static final Logger logger = LoggerFactory.getLogger(ConversationMessage.class);
    URI messageURI;
    URI senderAtomURI;
    Set<URI> proposes = new HashSet<URI>();
    Set<ConversationMessage> proposesRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> proposesInverseRefs = new HashSet<ConversationMessage>();
    Set<URI> claims = new HashSet<URI>();
    Set<ConversationMessage> claimsRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> claimsInverseRefs = new HashSet<ConversationMessage>();
    Set<URI> rejects = new HashSet<URI>();
    Set<ConversationMessage> rejectsRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> rejectsInverseRefs = new HashSet<ConversationMessage>();
    Set<URI> accepts = new HashSet<URI>();
    Set<ConversationMessage> acceptsRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> acceptsInverseRefs = new HashSet<ConversationMessage>();
    Set<URI> retracts = new HashSet<URI>();
    Set<ConversationMessage> retractsRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> retractsInverseRefs = new HashSet<ConversationMessage>();
    Set<URI> proposesToCancel = new HashSet<URI>();
    Set<ConversationMessage> proposesToCancelRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> proposesToCancelInverseRefs = new HashSet<ConversationMessage>();
    Set<URI> contentGraphs = new HashSet<URI>();
    Option<ConversationMessage> conversationRoot = Option.none();
    Set<URI> forwarded = new HashSet<URI>();
    Set<ConversationMessage> forwardedRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> forwardedInverseRefs = new HashSet<ConversationMessage>();
    Set<URI> previous = new HashSet<URI>();
    Set<ConversationMessage> previousRefs = new HashSet<ConversationMessage>();
    Set<ConversationMessage> previousInverseRefs = new HashSet<ConversationMessage>();
    URI respondingTo;
    Optional<ConversationMessage> respondingToOption = Optional.empty();
    ConversationMessage respondingToInverseRef;
    URI remotelyRespondingTo;
    ConversationMessage remotelyRespondingToRef;
    ConversationMessage remotelyRespondingToInverseRef;
    WonMessageType messageType;
    WonMessageDirection direction;
    DeliveryChain deliveryChain;
    private OptionalInt minDistanceToOwnRoot = OptionalInt.empty();
    private OptionalInt maxDistanceToOwnRoot = OptionalInt.empty();
    private OptionalInt order = OptionalInt.empty();
    private Set<ConversationMessage> knownMessagesOnPathToRoot = new HashSet<ConversationMessage>();
    private Set<MessageEffect> effects = Collections.EMPTY_SET;

    public ConversationMessage(URI messageURI) {
        this.messageURI = messageURI;
    }

    public void removeHighlevelProtocolProperties() {
        this.removeProposes();
        this.removeAccepts();
        this.removeProposesToCancel();
        this.removeRejects();
        this.removeRetracts();
        this.removeClaims();
    }

    private void removeProposes() {
        this.proposes = new HashSet<URI>();
        this.proposesRefs.forEach(other -> other.removeProposesInverseRef(this));
        this.proposesRefs = new HashSet<ConversationMessage>();
    }

    private void removeClaims() {
        this.claims = new HashSet<URI>();
        this.claimsRefs.forEach(other -> other.removeClaimsInverseRef(this));
        this.claimsRefs = new HashSet<ConversationMessage>();
    }

    private void removeProposesInverseRef(ConversationMessage other) {
        this.proposesInverseRefs.remove(other);
    }

    private void removeClaimsInverseRef(ConversationMessage other) {
        this.claimsInverseRefs.remove(other);
    }

    private void removeProposesToCancel() {
        this.proposesToCancel = new HashSet<URI>();
        this.proposesToCancelRefs.forEach(other -> other.removeProposesToCancelInverseRef(this));
        this.proposesToCancelRefs = new HashSet<ConversationMessage>();
    }

    private void removeProposesToCancelInverseRef(ConversationMessage other) {
        this.proposesInverseRefs.remove(other);
    }

    private void removeAccepts() {
        this.accepts = new HashSet<URI>();
        this.acceptsRefs.forEach(other -> other.removeAcceptsInverseRef(this));
        this.acceptsRefs = new HashSet<ConversationMessage>();
    }

    private void removeAcceptsInverseRef(ConversationMessage other) {
        this.acceptsInverseRefs.remove(other);
    }

    private void removeRejects() {
        this.rejects = new HashSet<URI>();
        this.rejectsRefs.forEach(other -> other.removeRejectsInverseRef(this));
        this.rejectsRefs = new HashSet<ConversationMessage>();
    }

    private void removeRejectsInverseRef(ConversationMessage other) {
        this.rejectsInverseRefs.remove(other);
    }

    private void removeRetracts() {
        this.retracts = new HashSet<URI>();
        this.retractsRefs.forEach(other -> other.removeRetractsInverseRef(this));
        this.retractsRefs = new HashSet<ConversationMessage>();
    }

    private void removeRetractsInverseRef(ConversationMessage other) {
        this.retractsInverseRefs.remove(other);
    }

    public boolean isForwardedMessage() {
        return !this.forwardedInverseRefs.isEmpty();
    }

    public ConversationMessage getRootOfDeliveryChain() {
        return this.getDeliveryChain().getHead();
    }

    public boolean isHeadOfDeliveryChain() {
        return this.isFromOwner() || this.isFromSystem() && !this.isResponse() || this.isFromSystem() && this.isResponse() && !this.getRespondingToOption().isPresent() && this.getRemotelyRespondingToRef() == null;
    }

    public boolean isEndOfDeliveryChain() {
        return this == this.getDeliveryChain().getEnd();
    }

    public boolean isInSameDeliveryChain(ConversationMessage other) {
        return this.getDeliveryChain() == other.getDeliveryChain();
    }

    public DeliveryChain getDeliveryChain() {
        Optional forwardingMsg;
        if (this.deliveryChain != null) {
            return this.deliveryChain;
        }
        if (this.isHeadOfDeliveryChain()) {
            this.deliveryChain = new DeliveryChain();
            this.deliveryChain.addMessage(this);
            return this.deliveryChain;
        }
        if (this.isResponse()) {
            Optional<Object> msg = Optional.empty();
            msg = this.getRespondingToOption().isPresent() ? this.getRespondingToOption() : Optional.ofNullable(this.getRemotelyRespondingToRef());
            if (msg.isPresent()) {
                this.deliveryChain = ((ConversationMessage)msg.get()).getDeliveryChain();
                if (this.deliveryChain != null) {
                    this.deliveryChain.addMessage(this);
                    return this.deliveryChain;
                }
            }
        }
        if (this.isForwardedMessage() && (forwardingMsg = this.getForwardedInverseRefs().stream().findFirst()).isPresent()) {
            this.deliveryChain = ((ConversationMessage)forwardingMsg.get()).getDeliveryChain();
            if (this.deliveryChain != null) {
                this.deliveryChain.addMessage(this);
                return this.deliveryChain;
            }
        }
        throw new IllegalStateException("did not manage to obtain the delivery chain for message " + this.getMessageURI());
    }

    public boolean isResponse() {
        return this.messageType == WonMessageType.SUCCESS_RESPONSE || this.messageType == WonMessageType.FAILURE_RESPONSE;
    }

    public boolean hasResponse() {
        return this.respondingToInverseRef != null;
    }

    public boolean hasRemoteResponse() {
        return this.remotelyRespondingToInverseRef != null;
    }

    public boolean hasSuccessResponse() {
        return this.hasResponse() && this.respondingToInverseRef.getMessageType() == WonMessageType.SUCCESS_RESPONSE;
    }

    public boolean hasRemoteSuccessResponse() {
        return this.hasRemoteResponse() && this.remotelyRespondingToInverseRef.getMessageType() == WonMessageType.SUCCESS_RESPONSE;
    }

    public boolean isAcknowledgedRemotely() {
        return this.hasSuccessResponse() && this.hasRemoteSuccessResponse();
    }

    public boolean previousMessage() {
        return !this.getPreviousRefs().isEmpty();
    }

    public boolean hasSubsequentMessage() {
        return !this.getPreviousInverseRefs().isEmpty();
    }

    public boolean respondingTo(ConversationMessage other) {
        return this.getRemotelyRespondingToRef() == other;
    }

    public boolean hasResponse(ConversationMessage other) {
        return other.getRespondingToOption().orElse(null) == this;
    }

    public boolean remotelyRespondingTo(ConversationMessage other) {
        return this.getRemotelyRespondingToRef() == other;
    }

    public boolean hasRemoteResponse(ConversationMessage other) {
        return other.getRemotelyRespondingToRef() == this;
    }

    public boolean partOfSameExchange(ConversationMessage other) {
        return this.getDeliveryChain() == other.getDeliveryChain();
    }

    @Override
    public int compareTo(ConversationMessage other) {
        int o2dist;
        if (this == other) {
            return 0;
        }
        int o1dist = this.getOrder();
        if (o1dist != (o2dist = other.getOrder())) {
            return o1dist - o2dist;
        }
        if (this.respondingTo(other)) {
            return 1;
        }
        if (this.remotelyRespondingTo(other)) {
            return 1;
        }
        if (this.isInSameDeliveryChain(other)) {
            if (this.isHeadOfDeliveryChain() || other.isEndOfDeliveryChain()) {
                return -1;
            }
            if (this.isEndOfDeliveryChain() || other.isHeadOfDeliveryChain()) {
                return 1;
            }
        }
        return this.getMessageURI().compareTo(other.getMessageURI());
    }

    public int getOrder() {
        if (this.order.isPresent()) {
            return this.order.getAsInt();
        }
        if (this.isHeadOfDeliveryChain()) {
            this.order = OptionalInt.of(Math.min(this.getRespondingToInverseRef() == null ? 0 : this.getRespondingToInverseRef().getOrder(), this.getRemotelyRespondingToInverseRef() == null ? 0 : this.getRemotelyRespondingToInverseRef().getOrder()));
            return this.order.getAsInt();
        }
        OptionalInt mindist = this.getPreviousRefs().stream().mapToInt(msg -> msg.getOrder() + 1).min();
        this.order = OptionalInt.of(mindist.orElse(0));
        return this.order.getAsInt();
    }

    public Option<ConversationMessage> getOwnConversationRoot() {
        if (this.conversationRoot.isDefined()) {
            return this.conversationRoot;
        }
        for (ConversationMessage prev : this.getPreviousRefs()) {
            Option<ConversationMessage> root = prev.getOwnConversationRoot();
            if (!root.isDefined()) continue;
            this.conversationRoot = Option.some((Object)root.get());
            return root;
        }
        this.conversationRoot = Option.some((Object)this);
        return this.conversationRoot;
    }

    public Set<ConversationMessage> getReachableConversationRoots() {
        HashSet<ConversationMessage> roots = new HashSet<ConversationMessage>();
        Option<ConversationMessage> ownRoot = this.getOwnConversationRoot();
        if (ownRoot.isDefined()) {
            roots.add((ConversationMessage)ownRoot.get());
        }
        return roots;
    }

    public boolean sharesReachableRootsWith(ConversationMessage other) {
        Set<ConversationMessage> myRoots = this.getReachableConversationRoots();
        return other.getReachableConversationRoots().stream().anyMatch(root -> myRoots.contains(root));
    }

    public boolean isAfter(ConversationMessage other) {
        if (this == other) {
            return false;
        }
        boolean foundIt = this.isAfter(other, new HashSet<ConversationMessage>());
        return foundIt;
    }

    private boolean isAfter(ConversationMessage other, Set<ConversationMessage> visited) {
        boolean result = false;
        if (this == other) {
            result = true;
        } else if (this.getOrder() < other.getOrder()) {
            result = false;
        } else if (this.knownMessagesOnPathToRoot.contains(other)) {
            result = true;
        } else if (this.isHeadOfDeliveryChain()) {
            ConversationMessage resp = this.getRespondingToInverseRef();
            ConversationMessage remoteResp = this.getRemotelyRespondingToInverseRef();
            if (resp != null || remoteResp != null) {
                boolean responseIsAfterOther = resp != null ? resp.isAfter(other, new HashSet<ConversationMessage>()) : true;
                boolean remoteResponseIsAfterOther = remoteResp != null ? remoteResp.isAfter(other, new HashSet<ConversationMessage>()) : true;
                result = responseIsAfterOther || remoteResponseIsAfterOther;
            }
        } else if (other.isHeadOfDeliveryChain()) {
            ConversationMessage otherResp = other.getRespondingToInverseRef();
            ConversationMessage otherRemoteResp = other.getRemotelyRespondingToInverseRef();
            if (otherResp != null || otherRemoteResp != null) {
                boolean isAfterOtherResponse = otherResp != null ? this.isAfter(otherResp, new HashSet<ConversationMessage>()) : true;
                boolean isAfterOtherRemoteResponse = otherRemoteResp != null ? this.isAfter(otherRemoteResp, new HashSet<ConversationMessage>()) : true;
                result = isAfterOtherResponse && isAfterOtherRemoteResponse;
            }
        } else {
            visited.add(this);
            result = this.getPreviousRefs().stream().filter(msg -> !visited.contains(msg)).anyMatch(msg -> msg.isAfter(other, visited));
        }
        if (result) {
            this.knownMessagesOnPathToRoot.add(other);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Checking if {} is after {}: {}", new Object[]{this.getMessageURI(), other.getMessageURI(), result});
        }
        return result;
    }

    public boolean isAgreementProtocolMessage() {
        return this.isRetractsMessage() || this.isProposesMessage() || this.isProposesToCancelMessage() || this.isAcceptsMessage() || this.isRejectsMessage() || this.isClaimsMessage();
    }

    public boolean isFromOwner() {
        return this.direction == WonMessageDirection.FROM_OWNER;
    }

    public boolean isFromExternal() {
        return this.direction == WonMessageDirection.FROM_EXTERNAL;
    }

    public boolean isFromSystem() {
        return this.direction == WonMessageDirection.FROM_SYSTEM;
    }

    public boolean isAcknowledgedLocally() {
        return this.hasSuccessResponse();
    }

    public boolean isRetractsMessage() {
        return !this.retractsRefs.isEmpty();
    }

    public boolean isAcceptsMessage() {
        return !this.acceptsRefs.isEmpty();
    }

    public boolean isProposesMessage() {
        return !this.proposesRefs.isEmpty();
    }

    public boolean isClaimsMessage() {
        return !this.claimsRefs.isEmpty();
    }

    public boolean isRejectsMessage() {
        return !this.rejectsRefs.isEmpty();
    }

    public boolean isProposesToCancelMessage() {
        return !this.proposesToCancelRefs.isEmpty();
    }

    public boolean proposes(ConversationMessage other) {
        return this.proposesRefs.contains(other);
    }

    public boolean claims(ConversationMessage other) {
        return this.claimsRefs.contains(other);
    }

    public boolean accepts(ConversationMessage other) {
        return this.acceptsRefs.contains(other);
    }

    public boolean proposesToCancel(ConversationMessage other) {
        return this.proposesToCancelRefs.contains(other);
    }

    public boolean retracts(ConversationMessage other) {
        return this.retractsRefs.contains(other);
    }

    public boolean rejects(ConversationMessage other) {
        return this.rejectsRefs.contains(other);
    }

    public URI getMessageURI() {
        return this.messageURI;
    }

    public URI getSenderAtomURI() {
        return this.senderAtomURI;
    }

    public void setSenderAtomURI(URI senderAtomURI) {
        this.senderAtomURI = senderAtomURI;
    }

    public Set<URI> getProposes() {
        return this.proposes;
    }

    public Set<URI> getClaims() {
        return this.claims;
    }

    public Set<URI> getRejects() {
        return this.rejects;
    }

    public Set<ConversationMessage> getProposesRefs() {
        return this.proposesRefs;
    }

    public void addProposes(URI proposes) {
        this.proposes.add(proposes);
    }

    public void addProposesRef(ConversationMessage ref) {
        this.proposesRefs.add(ref);
    }

    public Set<ConversationMessage> getClaimsRefs() {
        return this.claimsRefs;
    }

    public void addClaims(URI claims) {
        this.claims.add(claims);
    }

    public void addClaimsRef(ConversationMessage ref) {
        this.claimsRefs.add(ref);
    }

    public Set<ConversationMessage> getRejectsRefs() {
        return this.rejectsRefs;
    }

    public void addRejects(URI rejects) {
        this.rejects.add(rejects);
    }

    public void addRejectsRef(ConversationMessage ref) {
        this.rejectsRefs.add(ref);
    }

    public Set<URI> getPrevious() {
        return this.previous;
    }

    public Set<ConversationMessage> getPreviousRefs() {
        return this.previousRefs;
    }

    public void addPrevious(URI previous) {
        this.previous.add(previous);
    }

    public void addPreviousRef(ConversationMessage ref) {
        this.previousRefs.add(ref);
    }

    public Set<URI> getForwarded() {
        return this.forwarded;
    }

    public Set<ConversationMessage> getForwardedRefs() {
        return this.forwardedRefs;
    }

    public void addForwarded(URI forwarded) {
        this.forwarded.add(forwarded);
    }

    public void addForwardedRef(ConversationMessage ref) {
        this.forwardedRefs.add(ref);
    }

    public Set<URI> getAccepts() {
        return this.accepts;
    }

    public Set<ConversationMessage> getAcceptsRefs() {
        return this.acceptsRefs;
    }

    public void addAcceptsRef(ConversationMessage ref) {
        this.acceptsRefs.add(ref);
    }

    public void addAccepts(URI accepts) {
        this.accepts.add(accepts);
    }

    public Set<URI> getRetracts() {
        return this.retracts;
    }

    public Set<ConversationMessage> getRetractsRefs() {
        return this.retractsRefs;
    }

    public void addRetractsRef(ConversationMessage ref) {
        this.retractsRefs.add(ref);
    }

    public void addRetracts(URI retracts) {
        this.retracts.add(retracts);
    }

    public Set<URI> getProposesToCancel() {
        return this.proposesToCancel;
    }

    public Set<ConversationMessage> getProposesToCancelRefs() {
        return this.proposesToCancelRefs;
    }

    public void addProposesToCancelRef(ConversationMessage ref) {
        this.proposesToCancelRefs.add(ref);
    }

    public void addProposesToCancel(URI proposesToCancel) {
        this.proposesToCancel.add(proposesToCancel);
    }

    public URI getRespondingTo() {
        return this.respondingTo;
    }

    public void setRespondingTo(URI respondingTo) {
        this.respondingTo = respondingTo;
    }

    public Optional<ConversationMessage> getRespondingToOption() {
        return this.respondingToOption;
    }

    public void setRespondingToRef(ConversationMessage ref) {
        this.respondingToOption = Optional.ofNullable(ref);
    }

    public URI getRemotelyRespondingTo() {
        return this.remotelyRespondingTo;
    }

    public void setRemotelyRespondingTo(URI remotelyRespondingTo) {
        this.remotelyRespondingTo = remotelyRespondingTo;
    }

    public ConversationMessage getRemotelyRespondingToRef() {
        return this.remotelyRespondingToRef;
    }

    public void setRemotelyRespondingToRef(ConversationMessage ref) {
        this.remotelyRespondingToRef = ref;
    }

    public Set<ConversationMessage> getProposesInverseRefs() {
        return this.proposesInverseRefs;
    }

    public void addProposesInverseRef(ConversationMessage ref) {
        this.proposesInverseRefs.add(ref);
    }

    public Set<ConversationMessage> getClaimsInverseRefs() {
        return this.claimsInverseRefs;
    }

    public void addClaimsInverseRef(ConversationMessage ref) {
        this.claimsInverseRefs.add(ref);
    }

    public Set<ConversationMessage> getRejectsInverseRefs() {
        return this.rejectsInverseRefs;
    }

    public void addRejectsInverseRef(ConversationMessage ref) {
        this.rejectsInverseRefs.add(ref);
    }

    public Set<ConversationMessage> getPreviousInverseRefs() {
        return this.previousInverseRefs;
    }

    public void addPreviousInverseRef(ConversationMessage ref) {
        this.previousInverseRefs.add(ref);
    }

    public Set<ConversationMessage> getForwardedInverseRefs() {
        return this.forwardedInverseRefs;
    }

    public void addForwardedInverseRef(ConversationMessage ref) {
        this.forwardedInverseRefs.add(ref);
    }

    public Set<ConversationMessage> getAcceptsInverseRefs() {
        return this.acceptsInverseRefs;
    }

    public void addAcceptsInverseRef(ConversationMessage ref) {
        this.acceptsInverseRefs.add(ref);
    }

    public Set<ConversationMessage> getRetractsInverseRefs() {
        return this.retractsInverseRefs;
    }

    public void addRetractsInverseRef(ConversationMessage ref) {
        this.retractsInverseRefs.add(ref);
    }

    public ConversationMessage getRespondingToInverseRef() {
        return this.respondingToInverseRef;
    }

    public void setRespondingToInverseRef(ConversationMessage ref) {
        this.respondingToInverseRef = ref;
    }

    public ConversationMessage getRemotelyRespondingToInverseRef() {
        return this.remotelyRespondingToInverseRef;
    }

    public void setRemotelyRespondingToInverseRef(ConversationMessage ref) {
        this.remotelyRespondingToInverseRef = ref;
    }

    public Set<ConversationMessage> getProposesToCancelInverseRefs() {
        return this.proposesToCancelInverseRefs;
    }

    public void addProposesToCancelInverseRef(ConversationMessage ref) {
        this.proposesToCancelInverseRefs.add(ref);
    }

    public Set<URI> getContentGraphs() {
        return this.contentGraphs;
    }

    public void addContentGraph(URI contentGraph) {
        this.contentGraphs.add(contentGraph);
    }

    public WonMessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(WonMessageType messageType) {
        this.messageType = messageType;
    }

    public WonMessageDirection getDirection() {
        return this.direction;
    }

    public void setDirection(WonMessageDirection direction) {
        this.direction = direction;
    }

    public void setEffects(Set<MessageEffect> effects) {
        this.effects = effects;
    }

    public Set<MessageEffect> getEffects() {
        return this.effects;
    }

    public String toString() {
        return "ConversationMessage [messageURI=" + this.messageURI + ", order=" + this.getOrder() + ", direction=" + this.direction + ", messageType=" + this.messageType + ", deliveryChainPosition:" + (this == this.getDeliveryChain().getHead() ? "head" : (this == this.getDeliveryChain().getEnd() ? "end" : "middle")) + ", deliveryChainHead:" + this.getDeliveryChain().getHeadURI() + ", senderAtomURI=" + this.senderAtomURI + ", proposes=" + this.proposes + ", proposesRefs:" + this.proposesRefs.size() + ", claims=" + this.claims + ", claimsRefs:" + this.claimsRefs.size() + ", rejects=" + this.rejects + ", rejectsRefs:" + this.rejectsRefs.size() + ", previous=" + this.previous + ", previousRefs:" + this.previousRefs.size() + ", accepts=" + this.accepts + ", acceptsRefs:" + this.acceptsRefs.size() + ", retracts=" + this.retracts + ", retractsRefs:" + this.retractsRefs.size() + ", proposesToCancel=" + this.proposesToCancel + ", proposesToCancelRefs:" + this.proposesToCancelRefs.size() + ", respondingTo= " + this.respondingTo + ", remotelyRespondingTo=" + this.remotelyRespondingTo + ", respondingToRef: " + this.messageUriOrNullString(this.respondingToOption) + ", remotelyRespondingToRef:" + this.messageUriOrNullString(this.remotelyRespondingToRef) + ", respondingToInverse: " + this.messageUriOrNullString(this.respondingToInverseRef) + ", remotelyRespondingToInverse: " + this.messageUriOrNullString(this.remotelyRespondingToInverseRef) + ", isForwarded: " + this.isForwardedMessage() + "]";
    }

    private Object messageUriOrNullString(ConversationMessage message) {
        return message != null ? message.getMessageURI() : "null";
    }

    private Object messageUriOrNullString(Optional<ConversationMessage> messageOpt) {
        return messageOpt.isPresent() ? messageOpt.get().getMessageURI() : "null";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageURI == null ? 0 : this.messageURI.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConversationMessage other = (ConversationMessage)obj;
        return !(this.messageURI == null ? other.messageURI != null : !this.messageURI.equals(other.messageURI));
    }
}

