/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement.effect;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import won.protocol.agreement.effect.Accepts;
import won.protocol.agreement.effect.Claims;
import won.protocol.agreement.effect.MessageEffect;
import won.protocol.agreement.effect.Proposes;
import won.protocol.agreement.effect.Rejects;
import won.protocol.agreement.effect.Retracts;

public class MessageEffectsBuilder {
    private final URI messageUri;
    private Optional<Proposes> proposesOptional = Optional.empty();
    private Set<Accepts> accepts = new HashSet<Accepts>();
    private Set<Retracts> retracts = new HashSet<Retracts>();
    private Set<Rejects> rejects = new HashSet<Rejects>();
    private Set<Claims> claims = new HashSet<Claims>();

    public MessageEffectsBuilder(URI messageUri) {
        this.messageUri = messageUri;
    }

    public Set<MessageEffect> build() {
        HashSet<MessageEffect> ret = new HashSet<MessageEffect>();
        if (this.proposesOptional.isPresent()) {
            ret.add(this.proposesOptional.get());
        }
        ret.addAll(this.accepts);
        ret.addAll(this.rejects);
        ret.addAll(this.retracts);
        ret.addAll(this.claims);
        return ret;
    }

    public MessageEffectsBuilder proposes(URI uri) {
        if (!this.proposesOptional.isPresent()) {
            this.proposesOptional = Optional.of(new Proposes(this.messageUri));
        }
        this.proposesOptional.get().addProposes(uri);
        return this;
    }

    public MessageEffectsBuilder proposesToCancel(URI uri) {
        if (!this.proposesOptional.isPresent()) {
            this.proposesOptional = Optional.of(new Proposes(this.messageUri));
        }
        this.proposesOptional.get().addProposesToCancel(uri);
        return this;
    }

    public MessageEffectsBuilder accepts(URI uri, Collection<URI> cancelled) {
        this.accepts.add(new Accepts(this.messageUri, uri, cancelled));
        return this;
    }

    public MessageEffectsBuilder rejects(URI uri) {
        this.rejects.add(new Rejects(this.messageUri, uri));
        return this;
    }

    public MessageEffectsBuilder retracts(URI uri) {
        this.retracts.add(new Retracts(this.messageUri, uri));
        return this;
    }

    public MessageEffectsBuilder claims(URI uri) {
        this.claims.add(new Claims(this.messageUri, uri));
        return this;
    }
}

