/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import won.protocol.agreement.ConversationMessage;

public class DeliveryChain {
    private Set<ConversationMessage> messages = new HashSet<ConversationMessage>();
    private Set<DeliveryChain> interleavedDeliveryChains = new HashSet<DeliveryChain>();
    private Set<DeliveryChain> containedDeliveryChains = new HashSet<DeliveryChain>();
    private ConversationMessage head;

    public void addMessage(ConversationMessage msg) {
        if (msg.isHeadOfDeliveryChain()) {
            if (this.head != null && this.head != msg) {
                throw new IllegalArgumentException("Trying to add another head (" + msg.getMessageURI() + ") to delivery chain " + this.head.getMessageURI());
            }
            this.head = msg;
        }
        this.messages.add(msg);
    }

    public ConversationMessage getHead() {
        return this.head;
    }

    public boolean isTerminated() {
        if (this.head == null) {
            return false;
        }
        switch (this.head.getMessageType()) {
            case CREATE_ATOM: 
            case DEACTIVATE: 
            case ACTIVATE: 
            case HINT_FEEDBACK_MESSAGE: 
            case HINT_NOTIFICATION: 
            case ATOM_CREATED_NOTIFICATION: {
                return this.head.hasResponse();
            }
        }
        return this.head.hasResponse() && this.head.correspondingRemoteMessage() && this.head.getCorrespondingRemoteMessageRef().hasResponse() && this.head.getCorrespondingRemoteMessageRef().getIsResponseToInverseRef().correspondingRemoteMessage();
    }

    public ConversationMessage getEnd() {
        if (this.head == null) {
            return null;
        }
        switch (this.head.getMessageType()) {
            case CREATE_ATOM: 
            case DEACTIVATE: 
            case ACTIVATE: 
            case HINT_FEEDBACK_MESSAGE: 
            case HINT_NOTIFICATION: 
            case ATOM_CREATED_NOTIFICATION: {
                return this.head.getIsResponseToInverseRef();
            }
        }
        if (this.head.hasResponse() && this.head.correspondingRemoteMessage() && this.head.getCorrespondingRemoteMessageRef().hasResponse()) {
            return this.head.getCorrespondingRemoteMessageRef().getIsResponseToInverseRef().getCorrespondingRemoteMessageRef();
        }
        return null;
    }

    public URI getHeadURI() {
        return this.head.getMessageURI();
    }

    public Set<ConversationMessage> getMessages() {
        return this.messages;
    }

    public boolean isAfter(DeliveryChain other) {
        return other.getMessages().stream().anyMatch(msg -> this.getHead().isMessageOnPathToRoot((ConversationMessage)msg) || this.getHead().correspondingRemoteMessage() && this.getHead().getCorrespondingRemoteMessageRef().isMessageOnPathToRoot((ConversationMessage)msg));
    }

    private boolean _contains(DeliveryChain other) {
        if (!this.isTerminated()) {
            return false;
        }
        if (!this.getHead().sharesReachableRootsWith(other.getHead())) {
            return false;
        }
        return other.getMessages().stream().allMatch(msg -> {
            boolean isHeadBeforeAllOtherMsgs = msg.isMessageOnPathToRoot(this.getHead()) || this.getHead().correspondingRemoteMessage() && msg.isMessageOnPathToRoot(this.getHead().getCorrespondingRemoteMessageRef());
            boolean isEndAfterAllOtherMsgs = this.getEnd().isMessageOnPathToRoot((ConversationMessage)msg) || this.getEnd().correspondingRemoteMessage() && this.getEnd().getCorrespondingRemoteMessageRef().isMessageOnPathToRoot((ConversationMessage)msg);
            return isHeadBeforeAllOtherMsgs && isEndAfterAllOtherMsgs;
        });
    }

    private boolean _isInterleavedWith(DeliveryChain other) {
        if (this == other) {
            return false;
        }
        if (!this.getHead().sharesReachableRootsWith(other.getHead())) {
            return false;
        }
        return !this.isAfter(other) && !other.isAfter(this);
    }

    public boolean contains(DeliveryChain other) {
        return this.containedDeliveryChains.contains(other);
    }

    public boolean containsOtherChains() {
        return !this.containedDeliveryChains.isEmpty();
    }

    public void determineRelationshipWith(DeliveryChain other) {
        if (this == other) {
            return;
        }
        if (this.interleavedDeliveryChains.contains(other)) {
            return;
        }
        if (this.containedDeliveryChains.contains(other)) {
            return;
        }
        if (this._contains(other)) {
            this.containedDeliveryChains.add(other);
        } else if (this._isInterleavedWith(other)) {
            this.interleavedDeliveryChains.add(other);
            other.interleavedDeliveryChains.add(this);
        }
    }

    public boolean isInterleavedWith(DeliveryChain other) {
        return this.interleavedDeliveryChains.contains(other);
    }

    public Set<DeliveryChain> getInterleavedDeliveryChains() {
        return this.interleavedDeliveryChains;
    }

    public String toString() {
        return "DeliveryChain [head=" + this.head.getMessageURI() + ", isTerminated():" + this.isTerminated() + ", end:" + (this.getEnd() != null ? this.getEnd().getMessageURI() : "null") + ", interleaved with: " + (this.interleavedDeliveryChains.size() == 0 ? "none" : this.interleavedDeliveryChains.stream().map(x -> x.getHead())) + ", contains : " + (this.containedDeliveryChains.size() == 0 ? "none" : this.containedDeliveryChains.stream().map(x -> x.getHead())) + "]";
    }
}

