/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement;

import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import won.protocol.agreement.ConversationMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;

public class ConversationResultMapper
implements Function<QuerySolution, ConversationMessage> {
    private Map<URI, ConversationMessage> knownMessages = null;

    public ConversationResultMapper(Map messages) {
        this.knownMessages = messages;
    }

    public Map<URI, ConversationMessage> getKnownMessages() {
        return this.knownMessages;
    }

    @Override
    public ConversationMessage apply(QuerySolution solution) {
        URI contentGraph;
        URI direction;
        URI type;
        URI isRemoteResponseTo;
        URI isResponseTo;
        URI correspondingRemoteMessage;
        URI accepts;
        URI proposesToCancel;
        URI rejects;
        URI proposes;
        URI retracts;
        URI previous;
        URI senderAtomUri;
        URI messageUri = this.getUriVar(solution, "msg");
        ConversationMessage ret = this.knownMessages.get(messageUri);
        if (ret == null) {
            ret = new ConversationMessage(messageUri);
        }
        if ((senderAtomUri = this.getUriVar(solution, "senderAtom")) != null) {
            ret.setSenderAtomURI(senderAtomUri);
        }
        if ((previous = this.getUriVar(solution, "previous")) != null) {
            ret.addPrevious(previous);
        }
        if ((retracts = this.getUriVar(solution, "retracts")) != null) {
            ret.addRetracts(retracts);
        }
        if ((proposes = this.getUriVar(solution, "proposes")) != null) {
            ret.addProposes(proposes);
        }
        if ((rejects = this.getUriVar(solution, "rejects")) != null) {
            ret.addRejects(rejects);
        }
        if ((proposesToCancel = this.getUriVar(solution, "proposesToCancel")) != null) {
            ret.addProposesToCancel(proposesToCancel);
        }
        if ((accepts = this.getUriVar(solution, "accepts")) != null) {
            ret.addAccepts(accepts);
        }
        if ((correspondingRemoteMessage = this.getUriVar(solution, "correspondingRemoteMessage")) != null) {
            ret.setCorrespondingRemoteMessageURI(correspondingRemoteMessage);
        }
        if ((isResponseTo = this.getUriVar(solution, "isResponseTo")) != null) {
            ret.setIsResponseTo(isResponseTo);
        }
        if ((isRemoteResponseTo = this.getUriVar(solution, "isRemoteResponseTo")) != null) {
            ret.setIsRemoteResponseTo(isRemoteResponseTo);
        }
        if ((type = this.getUriVar(solution, "msgType")) != null) {
            ret.setMessageType(WonMessageType.getWonMessageType((URI)type));
        }
        if ((direction = this.getUriVar(solution, "direction")) != null) {
            ret.setDirection(WonMessageDirection.getWonMessageDirection((URI)direction));
        }
        if ((contentGraph = this.getUriVar(solution, "contentGraph")) != null) {
            ret.addContentGraph(contentGraph);
        }
        this.knownMessages.put(messageUri, ret);
        return ret;
    }

    private URI getUriVar(QuerySolution solution, String name) {
        RDFNode node = solution.get(name);
        if (node == null) {
            return null;
        }
        return URI.create(node.asResource().getURI());
    }
}

