/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.net.URI;
import java.util.function.Function;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.sse.SSE;
import won.protocol.util.SparqlSelectFunction;

public class WonMessageQueryBuilder<T> {
    private final SparqlSelectFunction<T> delegate;

    private WonMessageQueryBuilder(Function<QuerySolution, T> resultMapper) {
        this.delegate = new SparqlSelectFunction("/conversation/message.rq", resultMapper);
    }

    public static <M> WonMessageQueryBuilder<M> getBuilder(Function<QuerySolution, M> resultMapper) {
        return new WonMessageQueryBuilder<M>(resultMapper);
    }

    public static WonMessageQueryBuilder<URI> getBuilderForMessageUris() {
        return new WonMessageQueryBuilder<URI>(new SelectUriFunction());
    }

    public WonMessageQueryBuilder limit(int limit) {
        this.delegate.limit((long)limit);
        return this;
    }

    public WonMessageQueryBuilder offset(int offset) {
        this.delegate.offset((long)offset);
        return this;
    }

    public WonMessageQueryBuilder senderConnection(URI senderConnection) {
        QuerySolutionMap initialBinding = new QuerySolutionMap();
        initialBinding.add("senderConnection", (RDFNode)new ResourceImpl(senderConnection.toString()));
        this.delegate.addInitialBindings((QuerySolution)initialBinding);
        return this;
    }

    public WonMessageQueryBuilder senderNeed(URI senderNeed) {
        this.delegate.addInitialBinding("senderNeed", (RDFNode)new ResourceImpl(senderNeed.toString()));
        return this;
    }

    public WonMessageQueryBuilder messageUri(URI messageUri) {
        this.delegate.addInitialBinding("msg", (RDFNode)new ResourceImpl(messageUri.toString()));
        return this;
    }

    public WonMessageQueryBuilder isRetractsMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?retracts))"));
        return this;
    }

    public WonMessageQueryBuilder isProposesMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?proposes))"));
        return this;
    }

    public WonMessageQueryBuilder isProposesToCancelMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?proposesToCancel))"));
        return this;
    }

    public WonMessageQueryBuilder isAcceptsMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?accepts))"));
        return this;
    }

    public WonMessageQueryBuilder noResponses() {
        this.noFailureResponses();
        this.noSuccessResponses();
        return this;
    }

    public WonMessageQueryBuilder noFailureResponses() {
        this.delegate.having(SSE.parseExpr((String)"(!= ?msgType msg:FailureResponse)", (PrefixMapping)this.delegate.getPrefixMapping()));
        return this;
    }

    public WonMessageQueryBuilder noSuccessResponses() {
        this.delegate.having(SSE.parseExpr((String)"(!= ?msgType msg:SuccessResponse)", (PrefixMapping)this.delegate.getPrefixMapping()));
        return this;
    }

    public SparqlSelectFunction<T> build() {
        return this.delegate;
    }

    public static class SelectUriFunction
    implements Function<QuerySolution, URI> {
        @Override
        public URI apply(QuerySolution solution) {
            RDFNode uriNode = solution.get("uri");
            if (uriNode == null) {
                throw new IllegalStateException("Query has no variable named 'uri'");
            }
            if (!uriNode.isURIResource()) {
                throw new IllegalStateException("Value of result variable 'uri' is not a resource");
            }
            return URI.create(uriNode.asResource().getURI().toString());
        }
    }
}

