/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.agreement.AgreementProtocolState;
import won.protocol.agreement.IncompleteConversationDataException;
import won.protocol.rest.LinkedDataFetchingException;
import won.protocol.util.linkeddata.CachingLinkedDataSource;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

public class WonConversationUtils {
    private static final Logger logger = LoggerFactory.getLogger(WonConversationUtils.class);

    private static <T> T getFirstOrNull(Dataset dataset, Function<Dataset, List<T>> function) {
        List<T> results = function.apply(dataset);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public static URI getNthLatestMessage(Dataset conversationDataset, Predicate predicate, int n) {
        return AgreementProtocolState.of(conversationDataset).getNthLatestMessage(predicate, n);
    }

    public static URI getLatestMessageOfNeed(Dataset conversationDataset, URI senderNeed) {
        return AgreementProtocolState.of(conversationDataset).getLatestMessageSentByNeed(senderNeed);
    }

    public static URI getNthLatestMessageOfNeed(Dataset conversationDataset, URI senderNeed, int n) {
        return AgreementProtocolState.of(conversationDataset).getNthLatestMessageSentByNeed(senderNeed, n);
    }

    public static URI getLatestAcceptsMessageOfNeed(Dataset conversationDataset, URI senderNeed) {
        return AgreementProtocolState.of(conversationDataset).getLatestAcceptsMessageSentByNeed(senderNeed);
    }

    public static URI getLatestAcceptsMessage(Dataset conversationDataset) {
        return AgreementProtocolState.of(conversationDataset).getLatestAcceptsMessage();
    }

    public static URI getLatestRetractsMessageOfNeed(Dataset conversationDataset, URI senderNeed) {
        return AgreementProtocolState.of(conversationDataset).getLatestRetractsMessageSentByNeed(senderNeed);
    }

    public static URI getLatestProposesMessageOfNeed(Dataset conversationDataset, URI senderNeed) {
        return AgreementProtocolState.of(conversationDataset).getLatestProposesMessageSentByNeed(senderNeed);
    }

    public static URI getLatestProposesToCancelMessageOfNeed(Dataset conversationDataset, URI senderNeed) {
        return AgreementProtocolState.of(conversationDataset).getLatestProposesToCancelMessageSentByNeed(senderNeed);
    }

    public static URI getLatestRejectsMessageOfNeed(Dataset conversationDataset, URI senderNeed, int n) {
        return AgreementProtocolState.of(conversationDataset).getLatestRejectsMessageSentByNeed(senderNeed);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgreementProtocolState getAgreementProtocolState(URI connectionUri, LinkedDataSource linkedDataSource) {
        URI needUri = WonLinkedDataUtils.getNeedURIforConnectionURI((URI)connectionUri, (LinkedDataSource)linkedDataSource);
        HashSet<URI> recrawledForIncompleteness = new HashSet<URI>();
        HashSet<URI> recrawledForFailedFetch = new HashSet<URI>();
        while (true) {
            try {
                Dataset conversationDataset = WonLinkedDataUtils.getConversationAndNeedsDataset((URI)connectionUri, (LinkedDataSource)linkedDataSource);
                return AgreementProtocolState.of(conversationDataset);
            }
            catch (IncompleteConversationDataException e) {
                WonConversationUtils.refreshDataForConnection(connectionUri, needUri, linkedDataSource);
                if (WonConversationUtils.recrawl(recrawledForIncompleteness, connectionUri, needUri, linkedDataSource, e.getMissingMessageUri(), e.getReferringMessageUri())) continue;
                throw e;
            }
            catch (LinkedDataFetchingException e) {
                WonConversationUtils.refreshDataForConnection(connectionUri, needUri, linkedDataSource);
                if (!WonConversationUtils.recrawl(recrawledForFailedFetch, connectionUri, needUri, linkedDataSource, e.getResourceUri())) throw e;
                continue;
            }
            break;
        }
    }

    private static void refreshDataForConnection(URI connectionUri, URI needUri, LinkedDataSource linkedDataSource) {
        if (!(linkedDataSource instanceof CachingLinkedDataSource)) {
            return;
        }
        if (connectionUri == null) {
            return;
        }
        WonConversationUtils.invalidate(connectionUri, needUri, linkedDataSource);
        URI connectionEventContainerUri = WonLinkedDataUtils.getEventContainerURIforConnectionURI((URI)connectionUri, (LinkedDataSource)linkedDataSource);
        WonConversationUtils.invalidate(connectionEventContainerUri, needUri, linkedDataSource);
        URI remoteConnectionUri = WonLinkedDataUtils.getRemoteConnectionURIforConnectionURI((URI)connectionUri, (LinkedDataSource)linkedDataSource);
        if (remoteConnectionUri == null) {
            return;
        }
        WonConversationUtils.invalidate(remoteConnectionUri, needUri, linkedDataSource);
        URI remoteConnectionEventContainerUri = WonLinkedDataUtils.getEventContainerURIforConnectionURI((URI)remoteConnectionUri, (LinkedDataSource)linkedDataSource);
        WonConversationUtils.invalidate(remoteConnectionEventContainerUri, needUri, linkedDataSource);
    }

    private static boolean recrawl(Set<URI> recrawled, URI connectionUri, URI needUri, LinkedDataSource linkedDataSource, URI ... uris) {
        HashSet urisToCrawl = new HashSet();
        Arrays.stream(uris).filter(x -> !recrawled.contains(x)).forEach(urisToCrawl::add);
        if (urisToCrawl.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("connection {}: not recrawling again: {}", (Object)connectionUri, (Object)Arrays.toString(uris));
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("connection {}, recrawling: {}", (Object)connectionUri, urisToCrawl);
        }
        if (linkedDataSource instanceof CachingLinkedDataSource) {
            urisToCrawl.stream().forEach(uri -> WonConversationUtils.invalidate(uri, needUri, linkedDataSource));
        }
        recrawled.addAll(urisToCrawl);
        return true;
    }

    private static void invalidate(URI uri, URI webId, LinkedDataSource linkedDataSource) {
        if (!(linkedDataSource instanceof CachingLinkedDataSource)) {
            return;
        }
        if (uri != null) {
            ((CachingLinkedDataSource)linkedDataSource).invalidate(uri);
            if (webId != null) {
                ((CachingLinkedDataSource)linkedDataSource).invalidate(uri, webId);
            }
        }
    }
}

