/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.util;

import java.net.URI;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.sse.SSE;
import won.protocol.util.SparqlFunctionResultMapper;
import won.protocol.util.SparqlSelectFunction;

public class WonConversationQueryBuilder<T> {
    private final SparqlSelectFunction<T> delegate;

    private WonConversationQueryBuilder(SparqlFunctionResultMapper<T> resultMapper) {
        this.delegate = new SparqlSelectFunction("/conversation/messages.rq", resultMapper);
    }

    public static <T> WonConversationQueryBuilder<T> getBuilder(SparqlFunctionResultMapper<T> resultMapper) {
        return new WonConversationQueryBuilder<T>(resultMapper);
    }

    public static WonConversationQueryBuilder<URI> getBuilderForMessageUris() {
        return new WonConversationQueryBuilder<URI>(new SelectUriFunction());
    }

    public WonConversationQueryBuilder limit(int limit) {
        this.delegate.limit((long)limit);
        return this;
    }

    public WonConversationQueryBuilder offset(int offset) {
        this.delegate.offset((long)offset);
        return this;
    }

    public WonConversationQueryBuilder newestFirst() {
        this.delegate.addOrderBy("timestamp", -1);
        return this;
    }

    public WonConversationQueryBuilder oldestFirst() {
        this.delegate.addOrderBy("timestamp", 1);
        return this;
    }

    public WonConversationQueryBuilder senderNeed(URI senderNeed) {
        this.delegate.addInitialBinding("senderNeed", (RDFNode)new ResourceImpl(senderNeed.toString()));
        return this;
    }

    public WonConversationQueryBuilder isRetractsMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?retracts))"));
        return this;
    }

    public WonConversationQueryBuilder isProposesMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?proposes))"));
        return this;
    }

    public WonConversationQueryBuilder isProposesToCancelMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?proposesToCancel))"));
        return this;
    }

    public WonConversationQueryBuilder isRejectsMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?reject))"));
        return this;
    }

    public WonConversationQueryBuilder isAcceptsMessage() {
        this.delegate.having(SSE.parseExpr((String)"(bound(?accepts))"));
        return this;
    }

    public WonConversationQueryBuilder noResponses() {
        this.noFailureResponses();
        this.noSuccessResponses();
        return this;
    }

    public WonConversationQueryBuilder noFailureResponses() {
        this.delegate.having(SSE.parseExpr((String)"(!= ?msgType msg:FailureResponse)", (PrefixMapping)this.delegate.getPrefixMapping()));
        return this;
    }

    public WonConversationQueryBuilder noSuccessResponses() {
        this.delegate.having(SSE.parseExpr((String)"(!= ?msgType msg:SuccessResponse)", (PrefixMapping)this.delegate.getPrefixMapping()));
        return this;
    }

    public SparqlSelectFunction<T> build() {
        return this.delegate;
    }

    public static class SelectUriFunction
    implements SparqlFunctionResultMapper<URI> {
        @Override
        public URI apply(QuerySolution solution) {
            RDFNode uriNode = solution.get("uri");
            if (uriNode == null) {
                throw new IllegalStateException("Query has no variable named 'uri'");
            }
            if (!uriNode.isURIResource()) {
                throw new IllegalStateException("Value of result variable 'uri' is not a resource");
            }
            return URI.create(uriNode.asResource().getURI().toString());
        }
    }
}

