/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement.effect;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import won.protocol.agreement.effect.MessageEffect;
import won.protocol.agreement.effect.MessageEffectType;
import won.protocol.agreement.effect.ProposalType;

public class Proposes
extends MessageEffect {
    private Set<URI> proposes = new HashSet<URI>();
    private Set<URI> proposesToCancel = new HashSet<URI>();

    public Proposes(URI messageUri) {
        super(messageUri, MessageEffectType.PROPOSES);
    }

    void addProposes(URI uri) {
        this.proposes.add(uri);
    }

    void addProposesToCancel(URI uri) {
        this.proposesToCancel.add(uri);
    }

    public Set<URI> getProposes() {
        return this.proposes;
    }

    public Set<URI> getProposesToCancel() {
        return this.proposesToCancel;
    }

    public boolean hasCancellations() {
        return !this.proposesToCancel.isEmpty();
    }

    public boolean hasClauses() {
        return !this.proposes.isEmpty();
    }

    public ProposalType getProposalType() {
        if (this.hasClauses()) {
            if (this.hasCancellations()) {
                return ProposalType.PROPOSES_AND_CANCELS;
            }
            return ProposalType.PROPOSES;
        }
        if (this.hasCancellations()) {
            return ProposalType.CANCELS;
        }
        return ProposalType.NONE;
    }

    public String toString() {
        return "Proposes [proposes=" + this.proposes + ", proposesToCancel=" + this.proposesToCancel + "]";
    }
}

