/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement.effect;

import java.net.URI;
import won.protocol.agreement.effect.Accepts;
import won.protocol.agreement.effect.MessageEffectType;
import won.protocol.agreement.effect.Proposes;
import won.protocol.agreement.effect.Rejects;
import won.protocol.agreement.effect.Retracts;

public abstract class MessageEffect {
    private final URI messageUri;
    private final MessageEffectType type;

    public MessageEffect(URI messageUri, MessageEffectType types) {
        this.messageUri = messageUri;
        this.type = types;
    }

    public URI getMessageUri() {
        return this.messageUri;
    }

    public MessageEffectType getType() {
        return this.type;
    }

    public boolean isAccepts() {
        return this.type == MessageEffectType.ACCEPTS;
    }

    public boolean isProposes() {
        return this.type == MessageEffectType.PROPOSES;
    }

    public boolean isRejects() {
        return this.type == MessageEffectType.REJECTS;
    }

    public boolean isRetracts() {
        return this.type == MessageEffectType.RETRACTS;
    }

    public Accepts asAccepts() {
        return (Accepts)this;
    }

    public Proposes asProposes() {
        return (Proposes)this;
    }

    public Rejects asRejects() {
        return (Rejects)this;
    }

    public Retracts asRetracts() {
        return (Retracts)this;
    }
}

