/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import won.protocol.agreement.ConversationMessage;
import won.protocol.message.WonMessageDirection;
import won.protocol.message.WonMessageType;
import won.protocol.util.RdfUtils;
import won.protocol.vocabulary.WONAGR;
import won.protocol.vocabulary.WONMOD;
import won.protocol.vocabulary.WONMSG;

public class ConversationMessagesReader {
    static final Map<Property, BiConsumer<Map<URI, ConversationMessage>, Statement>> handlers;

    public static Map<URI, ConversationMessage> readConversationMessages(Dataset dataset) {
        HashMap<URI, ConversationMessage> messages = new HashMap<URI, ConversationMessage>();
        RdfUtils.toStatementStream((Dataset)dataset).forEach(stmt -> {
            BiConsumer<Map<URI, ConversationMessage>, Statement> handler = handlers.get(stmt.getPredicate());
            if (handler != null) {
                handler.accept((Map<URI, ConversationMessage>)messages, (Statement)stmt);
            }
        });
        return messages;
    }

    private static URI getUri(RDFNode node) {
        if (!node.isResource() || node.isAnon()) {
            return null;
        }
        return URI.create(node.asResource().getURI());
    }

    private static ConversationMessage getOrCreateMessage(Map<URI, ConversationMessage> messages, URI uri) {
        ConversationMessage msg = messages.get(uri);
        if (msg == null) {
            msg = new ConversationMessage(uri);
            messages.put(uri, msg);
        }
        return msg;
    }

    static {
        HashMap<Property, BiConsumer<Map, Statement>> inithandlers = new HashMap<Property, BiConsumer<Map, Statement>>();
        inithandlers.put(WONMSG.SENDER_NEED_PROPERTY, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).setSenderNeedURI(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONMSG.HAS_CORRESPONDING_REMOTE_MESSAGE, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).setCorrespondingRemoteMessageURI(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONMSG.HAS_PREVIOUS_MESSAGE_PROPERTY, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).addPrevious(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONMSG.IS_RESPONSE_TO, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).setIsResponseTo(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONMSG.IS_REMOTE_RESPONSE_TO, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).setIsRemoteResponseTo(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONMSG.HAS_MESSAGE_TYPE_PROPERTY, (messages, s) -> {
            URI uri = ConversationMessagesReader.getUri(s.getObject());
            if (uri == null) {
                return;
            }
            WonMessageType type = WonMessageType.getWonMessageType((URI)uri);
            if (type == null) {
                return;
            }
            ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).setMessageType(type);
        });
        inithandlers.put(RDF.type, (messages, s) -> {
            URI uri = ConversationMessagesReader.getUri(s.getObject());
            if (uri == null) {
                return;
            }
            WonMessageDirection direction = WonMessageDirection.getWonMessageDirection((URI)uri);
            if (direction == null) {
                return;
            }
            ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).setDirection(direction);
        });
        inithandlers.put(WONMSG.HAS_CONTENT_PROPERTY, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).addContentGraph(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONMOD.RETRACTS, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).addRetracts(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONAGR.PROPOSES, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).addProposes(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONAGR.PROPOSES_TO_CANCEL, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).addProposesToCancel(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONAGR.REJECTS, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).addRejects(ConversationMessagesReader.getUri(s.getObject())));
        inithandlers.put(WONAGR.ACCEPTS, (messages, s) -> ConversationMessagesReader.getOrCreateMessage(messages, ConversationMessagesReader.getUri((RDFNode)s.getSubject())).addAccepts(ConversationMessagesReader.getUri(s.getObject())));
        handlers = Collections.unmodifiableMap(inithandlers);
    }
}

