/*
 * Decompiled with CFR 0.152.
 */
package won.protocol.agreement;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import won.protocol.agreement.AgreementProtocolUris;
import won.protocol.agreement.ConversationMessage;
import won.protocol.agreement.ConversationMessagesReader;
import won.protocol.agreement.DeliveryChain;
import won.protocol.agreement.IncompleteConversationDataException;
import won.protocol.agreement.ProposalUris;
import won.protocol.agreement.effect.MessageEffect;
import won.protocol.agreement.effect.MessageEffectsBuilder;
import won.protocol.agreement.effect.ProposalType;
import won.protocol.message.WonMessageDirection;
import won.protocol.util.RdfUtils;
import won.protocol.util.WonRdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;
import won.protocol.vocabulary.WONAGR;

public class AgreementProtocolState {
    private final Logger logger = LoggerFactory.getLogger(AgreementProtocolState.class);
    private final Dataset pendingProposals = DatasetFactory.createGeneral();
    private final Dataset agreements = DatasetFactory.createGeneral();
    private final Dataset cancelledAgreements = DatasetFactory.createGeneral();
    private final Dataset rejected = DatasetFactory.createGeneral();
    private Dataset conversation = null;
    private final Set<URI> retractedUris = new HashSet<URI>();
    private final Set<URI> acceptedCancellationProposalUris = new HashSet<URI>();
    private Map<URI, ConversationMessage> messagesByURI = new HashMap<URI, ConversationMessage>();
    private Set<DeliveryChain> deliveryChains = new HashSet<DeliveryChain>();

    public static AgreementProtocolState of(URI connectionURI, LinkedDataSource linkedDataSource) {
        Dataset fullConversationDataset = WonLinkedDataUtils.getConversationAndNeedsDataset((URI)connectionURI, (LinkedDataSource)linkedDataSource);
        return AgreementProtocolState.of(fullConversationDataset);
    }

    public static AgreementProtocolState of(Dataset conversation) {
        AgreementProtocolState instance = new AgreementProtocolState();
        instance.recalculate(conversation);
        return instance;
    }

    private AgreementProtocolState() {
    }

    public AgreementProtocolUris getAgreementProtocolUris() {
        AgreementProtocolUris uris = new AgreementProtocolUris();
        uris.addAgreementUris(this.getAgreementUris());
        uris.addAcceptedCancellationProposalUris(this.getAcceptedCancellationProposalUris());
        uris.addCancelledAgreementUris(this.getCancelledAreementUris());
        this.messagesByURI.values().stream().filter(m -> this.isPendingProposal(m.getMessageURI())).forEach(m -> {
            Set<URI> cancelled = m.getEffects().stream().filter(e -> e.isProposes()).map(e -> e.asProposes()).flatMap(e -> e.getProposesToCancel().stream()).filter(this::isAgreement).collect(Collectors.toSet());
            Set<URI> proposed = m.getEffects().stream().filter(e -> e.isProposes()).map(e -> e.asProposes()).flatMap(e -> e.getProposes().stream()).collect(Collectors.toSet());
            uris.addCancellationPendingAgreementUris(cancelled);
            boolean isProposal = false;
            if (!cancelled.isEmpty()) {
                uris.addPendingCancellationProposalUri(m.getMessageURI());
                isProposal = true;
            }
            if (!proposed.isEmpty()) {
                uris.addPendingProposalUri(m.getMessageURI());
                isProposal = true;
            }
            if (isProposal) {
                ProposalUris proposal = new ProposalUris(m.getMessageURI(), m.getSenderNeedURI());
                proposal.addProposes(proposed);
                proposal.addProposesToCancel(cancelled);
                uris.addPendingProposal(proposal);
            }
        });
        uris.addRejectedMessageUris(this.getRejectedUris());
        uris.addRetractedMessageUris(this.getRetractedUris());
        return uris;
    }

    public Dataset getConversationDataset() {
        return this.conversation;
    }

    public Set<MessageEffect> getEffects(URI messageUri) {
        ConversationMessage message = this.messagesByURI.get(messageUri);
        if (message == null) {
            return Collections.EMPTY_SET;
        }
        return message.getDeliveryChain().getHead().getEffects();
    }

    public Dataset getAgreements() {
        return this.agreements;
    }

    public Model getAgreement(URI agreementURI) {
        return this.agreements.getNamedModel(agreementURI.toString());
    }

    public boolean isAgreement(URI agreementUri) {
        return this.agreements.containsNamedModel(agreementUri.toString());
    }

    public Dataset getPendingProposals() {
        return this.pendingProposals;
    }

    public Model getPendingProposal(URI proposalURI) {
        return this.pendingProposals.getNamedModel(proposalURI.toString());
    }

    public boolean isPendingProposal(URI proposalUri) {
        return this.pendingProposals.containsNamedModel(proposalUri.toString()) || this.isPendingCancellation(proposalUri);
    }

    public Set<URI> getPendingProposalUris() {
        Set uris = RdfUtils.getGraphUris((Dataset)this.pendingProposals);
        uris.addAll(this.getPendingCancellationProposalUris());
        return uris;
    }

    public Set<URI> getClauseUrisProposedByPendingProposal(URI proposalUri) {
        if (!this.isPendingProposal(proposalUri)) {
            return Collections.EMPTY_SET;
        }
        ConversationMessage msg = this.messagesByURI.get(proposalUri);
        return msg.getEffects().stream().filter(e -> e.isProposes()).map(e -> e.asProposes()).filter(e -> e.hasClauses()).flatMap(e -> e.getProposes().stream()).collect(Collectors.toSet());
    }

    public Set<URI> getAgreementUrisCancelledByPendingProposal(URI proposalUri) {
        if (!this.isPendingProposal(proposalUri)) {
            return Collections.EMPTY_SET;
        }
        ConversationMessage msg = this.messagesByURI.get(proposalUri);
        return msg.getEffects().stream().filter(e -> e.isProposes()).map(e -> e.asProposes()).filter(e -> e.hasCancellations()).flatMap(e -> e.getProposesToCancel().stream()).collect(Collectors.toSet());
    }

    public Set<URI> getPendingCancellationProposalUris() {
        Model cancellations = this.pendingProposals.getDefaultModel();
        if (cancellations == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<URI> ret = new HashSet<URI>();
        ResIterator it = cancellations.listSubjectsWithProperty(WONAGR.PROPOSES_TO_CANCEL);
        while (it.hasNext()) {
            String uri = ((Resource)it.next()).asResource().getURI();
            ret.add(URI.create(uri));
        }
        return ret;
    }

    public Dataset getCancelledAgreements() {
        return this.cancelledAgreements;
    }

    public Model getCancelledAgreement(URI cancelledAgreementURI) {
        return this.cancelledAgreements.getNamedModel(cancelledAgreementURI.toString());
    }

    public boolean isCancelledAgreement(URI agreementUri) {
        return this.cancelledAgreements.containsNamedModel(agreementUri.toString());
    }

    public Dataset getRejectedProposals() {
        return this.rejected;
    }

    public Model getRejectedProposal(URI rejectedProposalURI) {
        return this.rejected.getNamedModel(rejectedProposalURI.toString());
    }

    public boolean isRejectedProposal(URI rejectedProposalUri) {
        return this.rejected.containsNamedModel(rejectedProposalUri.toString());
    }

    public Model getPendingCancellations() {
        return this.pendingProposals.getDefaultModel();
    }

    public boolean isPendingCancellation(URI proposalUri) {
        return this.pendingProposals.getDefaultModel().contains((Resource)new ResourceImpl(proposalUri.toString()), WONAGR.PROPOSES_TO_CANCEL, (RDFNode)null);
    }

    public Set<URI> getAgreementUris() {
        return RdfUtils.getGraphUris((Dataset)this.agreements);
    }

    public Set<URI> getCancelledAreementUris() {
        return RdfUtils.getGraphUris((Dataset)this.cancelledAgreements);
    }

    public Set<URI> getRetractedUris() {
        return this.retractedUris;
    }

    public Set<URI> getAcceptedCancellationProposalUris() {
        return this.acceptedCancellationProposalUris;
    }

    public Set<URI> getCancellationPendingAgreementUris() {
        Model cancellations = this.pendingProposals.getDefaultModel();
        if (cancellations == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<URI> ret = new HashSet<URI>();
        NodeIterator it = cancellations.listObjectsOfProperty(WONAGR.PROPOSES_TO_CANCEL);
        while (it.hasNext()) {
            String uri = it.next().asResource().getURI();
            ret.add(URI.create(uri));
        }
        return ret;
    }

    public Set<URI> getRejectedUris() {
        return RdfUtils.getGraphUris((Dataset)this.rejected);
    }

    private Stream<ConversationMessage> getMessagesAsOrderedStream(Predicate<ConversationMessage> filterPredicate) {
        return this.deliveryChains.stream().map(m -> m.getHead()).filter(x -> filterPredicate.test((ConversationMessage)x)).sorted((x1, x2) -> x2.getOrder() - x1.getOrder());
    }

    public List<URI> getNLatestMessageUris(Predicate<ConversationMessage> filterPredicate, int n) {
        List<URI> uris = this.getMessagesAsOrderedStream(filterPredicate).map(m -> m.getMessageURI()).collect(Collectors.toList());
        if (uris.size() > n) {
            return uris.subList(0, n);
        }
        return uris;
    }

    public URI getNthLatestMessage(Predicate<ConversationMessage> filterPredicate, int n) {
        List<URI> uris = this.getNLatestMessageUris(filterPredicate, n + 1);
        if (uris.size() > n) {
            return uris.get(n);
        }
        return null;
    }

    private void logNthLatestMessage(int n, URI needUri, String type, URI result) {
        this.logger.debug(n + "-th latest message " + (type == null ? "" : "of type " + type) + (needUri == null ? "" : " sent by " + needUri) + ": " + (result == null ? " none found" : needUri));
    }

    public URI getLatestMessageSentByNeed(URI needUri) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, needUri, null, uri);
        }
        return uri;
    }

    public URI getNthLatestMessageSentByNeed(URI needUri, int n) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()), n);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(n, needUri, null, uri);
        }
        return uri;
    }

    public URI getLatestProposesMessageSentByNeed(URI needUri) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()) && m.isProposesMessage() && m.getEffects().stream().anyMatch(e -> e.isProposes()), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, needUri, null, uri);
        }
        return uri;
    }

    public URI getLatestPendingProposesMessageSentByNeed(URI needUri) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()) && m.isProposesMessage() && m.getEffects().stream().anyMatch(e -> e.isProposes() && this.isPendingProposal(m.getMessageURI())), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, needUri, null, uri);
        }
        return uri;
    }

    public URI getLatestAcceptsMessageSentByNeed(URI needUri) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()) && m.isAcceptsMessage() && m.getEffects().stream().anyMatch(e -> e.isAccepts()), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, needUri, null, uri);
        }
        return uri;
    }

    public URI getLatestAgreement() {
        return this.getLatestAgreement(Optional.empty());
    }

    public URI getLatestAgreement(Optional<URI> senderNeedUri) {
        Optional<ConversationMessage> acceptMsgOpt = this.getMessagesAsOrderedStream(m -> m.isAcceptsMessage() && (!senderNeedUri.isPresent() || ((URI)senderNeedUri.get()).equals(m.getSenderNeedURI())) && m.getEffects().stream().filter(e -> e.isAccepts()).map(e -> e.asAccepts()).map(a -> a.getAcceptedMessageUri()).anyMatch(this::isAgreement)).findFirst();
        if (!acceptMsgOpt.isPresent()) {
            return null;
        }
        return acceptMsgOpt.get().getEffects().stream().map(e -> e.asAccepts().getAcceptedMessageUri()).filter(this::isAgreement).findFirst().get();
    }

    public URI getLatestAcceptsMessage() {
        URI uri = this.getNthLatestMessage(m -> m.isAcceptsMessage() && m.getEffects().stream().anyMatch(e -> e.isAccepts()), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, null, null, uri);
        }
        return uri;
    }

    public URI getLatestProposesToCancelMessageSentByNeed(URI needUri) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()) && m.isProposesToCancelMessage() && m.getEffects().stream().anyMatch(e -> e.isProposes() && e.asProposes().hasCancellations()), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, needUri, null, uri);
        }
        return uri;
    }

    public URI getLatestPendingProposal() {
        return this.getLatestPendingProposal(Optional.empty(), Optional.empty());
    }

    public URI getLatestPendingProposal(Optional<ProposalType> type) {
        return this.getLatestPendingProposal(type, Optional.empty());
    }

    public URI getLatestPendingProposal(Optional<ProposalType> type, Optional<URI> senderNeedUri) {
        URI uri = this.getNthLatestMessage(m -> !(!m.isProposesMessage() && !m.isProposesToCancelMessage() || senderNeedUri.isPresent() && !((URI)senderNeedUri.get()).equals(m.getSenderNeedURI()) || !m.getEffects().stream().filter(e -> e.isProposes() && (!type.isPresent() || e.asProposes().getProposalType() == type.get())).map(e -> e.getMessageUri()).anyMatch(msgUri -> this.isPendingProposal((URI)msgUri) || this.isPendingCancellation((URI)msgUri))), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, senderNeedUri.orElse(null), null, uri);
        }
        return uri;
    }

    public URI getLatestRejectsMessageSentByNeed(URI needUri) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()) && m.isRejectsMessage() && m.getEffects().stream().anyMatch(e -> e.isRejects()), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, needUri, null, uri);
        }
        return uri;
    }

    public URI getLatestRetractsMessageSentByNeed(URI needUri) {
        URI uri = this.getNthLatestMessage(m -> needUri.equals(m.getSenderNeedURI()) && m.isRetractsMessage() && m.getEffects().stream().anyMatch(e -> e.isRetracts()), 0);
        if (this.logger.isDebugEnabled()) {
            this.logNthLatestMessage(0, needUri, null, uri);
        }
        return uri;
    }

    public Optional<String> getTextMessage(URI messageUri) {
        ConversationMessage msg = this.messagesByURI.get(messageUri);
        if (msg == null) {
            return Optional.empty();
        }
        ConversationMessage head = msg.getDeliveryChain().getHead();
        if (head == null) {
            return Optional.empty();
        }
        return head.getContentGraphs().stream().flatMap(contentGraphURI -> WonRdfUtils.MessageUtils.getTextMessages((Model)this.conversation.getNamedModel(contentGraphURI.toString()), (URI)head.getMessageURI()).stream()).reduce((msg1, msg2) -> msg1 + ", " + msg2);
    }

    private void recalculate(Dataset conversationDataset) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("starting conversation analysis for high-level protocols");
        }
        this.pendingProposals.begin(ReadWrite.WRITE);
        this.agreements.begin(ReadWrite.WRITE);
        this.cancelledAgreements.begin(ReadWrite.WRITE);
        this.rejected.begin(ReadWrite.WRITE);
        conversationDataset.begin(ReadWrite.READ);
        this.messagesByURI = ConversationMessagesReader.readConversationMessages(conversationDataset);
        HashSet roots = new HashSet();
        Collection<ConversationMessage> messages = this.messagesByURI.values();
        messages.stream().forEach(message -> {
            ConversationMessage other;
            if (message.getCorrespondingRemoteMessageURI() != null && !message.getCorrespondingRemoteMessageURI().equals(message.getMessageURI())) {
                other = this.messagesByURI.get(message.getCorrespondingRemoteMessageURI());
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), message.getCorrespondingRemoteMessageURI(), other, "msg:hasCorrespondingRemoteMessage");
                message.setCorrespondingRemoteMessageRef(other);
                other.setCorrespondingRemoteMessageRef((ConversationMessage)message);
            }
            message.getPrevious().stream().filter(uri -> !uri.equals(message.getMessageURI())).forEach(uri -> {
                ConversationMessage other = this.messagesByURI.get(uri);
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), (URI)uri, other, "msg:hasPreviousMessage");
                message.addPreviousRef(other);
                other.addPreviousInverseRef((ConversationMessage)message);
            });
            message.getAccepts().stream().filter(uri -> !uri.equals(message.getMessageURI())).forEach(uri -> {
                ConversationMessage other = this.messagesByURI.get(uri);
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), (URI)uri, other, "agr:accepts");
                message.addAcceptsRef(other);
                other.addAcceptsInverseRef((ConversationMessage)message);
            });
            message.getProposes().stream().filter(uri -> !uri.equals(message.getMessageURI())).forEach(uri -> {
                ConversationMessage other = this.messagesByURI.get(uri);
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), (URI)uri, other, "agr:proposes");
                message.addProposesRef(other);
                other.addProposesInverseRef((ConversationMessage)message);
            });
            message.getRejects().stream().filter(uri -> !uri.equals(message.getMessageURI())).forEach(uri -> {
                ConversationMessage other = this.messagesByURI.get(uri);
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), (URI)uri, other, "agr:rejects");
                message.addRejectsRef(other);
                other.addRejectsInverseRef((ConversationMessage)message);
            });
            message.getProposesToCancel().stream().filter(uri -> !uri.equals(message.getMessageURI())).forEach(uri -> {
                ConversationMessage other = this.messagesByURI.get(uri);
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), (URI)uri, other, "agr:proposesToCancel");
                message.addProposesToCancelRef(other);
                other.addProposesToCancelInverseRef((ConversationMessage)message);
            });
            message.getRetracts().stream().filter(uri -> !uri.equals(message.getMessageURI())).forEach(uri -> {
                ConversationMessage other = this.messagesByURI.get(uri);
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), (URI)uri, other, "mod:retracts");
                message.addRetractsRef(other);
                other.addRetractsInverseRef((ConversationMessage)message);
            });
            if (message.getIsResponseTo() != null && !message.getIsResponseTo().equals(message.getMessageURI())) {
                other = this.messagesByURI.get(message.getIsResponseTo());
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), message.getIsResponseTo(), other, "msg:isResponseTo");
                message.setIsResponseToRef(other);
                other.setIsResponseToInverseRef((ConversationMessage)message);
            }
            if (message.getIsRemoteResponseTo() != null && !message.getIsRemoteResponseTo().equals(message.getMessageURI())) {
                other = this.messagesByURI.get(message.getIsRemoteResponseTo());
                this.throwExceptionIfOtherisMissing(message.getMessageURI(), message.getIsRemoteResponseTo(), other, "msg:isRemoteResponseTo");
                message.setIsRemoteResponseToRef(other);
                other.setIsRemoteResponseToInverseRef((ConversationMessage)message);
            }
            if (message.getPrevious().isEmpty()) {
                roots.add(message);
            }
        });
        this.deliveryChains = messages.stream().map(m -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("deliveryChain for message {}: {}", (Object)m.getMessageURI(), (Object)m.getDeliveryChain());
            }
            return m.getDeliveryChain();
        }).collect(Collectors.toSet());
        this.deliveryChains.stream().forEach(dc -> this.deliveryChains.stream().forEach(dc2 -> dc.determineRelationshipWith((DeliveryChain)dc2)));
        this.conversation = this.acknowledgedSelection(conversationDataset, messages);
        PriorityQueue<ConversationMessage> currentMessages = new PriorityQueue<ConversationMessage>();
        currentMessages.addAll(messages);
        HashSet<ConversationMessage> processed = new HashSet<ConversationMessage>();
        ArrayList<ConversationMessage> processedInOrder = null;
        if (this.logger.isDebugEnabled()) {
            processedInOrder = new ArrayList<ConversationMessage>();
        }
        ConversationMessage last = null;
        while (!currentMessages.isEmpty()) {
            ConversationMessage msg = (ConversationMessage)currentMessages.poll();
            if (processed.contains(msg)) continue;
            processed.add(msg);
            MessageEffectsBuilder effectsBuilder = new MessageEffectsBuilder(msg.getMessageURI());
            if (this.logger.isDebugEnabled() && processedInOrder != null) {
                processedInOrder.add(msg);
            }
            last = msg;
            if (!msg.isHeadOfDeliveryChain() || !msg.isAgreementProtocolMessage()) continue;
            if (msg.isRetractsMessage()) {
                this.removeContentGraphs(this.conversation, msg);
                if (this.logger.isDebugEnabled()) {
                    msg.getRetractsRefs().forEach(other -> this.logger.debug("{} retracts {}", (Object)msg.getMessageURI(), (Object)other.getMessageURI()));
                }
                msg.getRetractsRefs().stream().filter(other -> msg != other).filter(other -> other.getSenderNeedURI().equals(msg.getSenderNeedURI())).filter(other -> other.isHeadOfDeliveryChain()).filter(other -> msg.isMessageOnPathToRoot((ConversationMessage)other)).forEach(other -> {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("{} retracts {}: valid, computing effects", (Object)msg.getMessageURI(), (Object)other.getMessageURI());
                    }
                    boolean changedSomething = false;
                    changedSomething = this.removeContentGraphs(this.conversation, (ConversationMessage)other) || changedSomething;
                    this.retractedUris.add(other.getMessageURI());
                    if (other.isProposesMessage() || other.isProposesToCancelMessage()) {
                        boolean bl = changedSomething = this.retractProposal(other.getMessageURI()) || changedSomething;
                    }
                    if (changedSomething) {
                        effectsBuilder.retracts(other.getMessageURI());
                    }
                });
            }
            if (msg.isRejectsMessage()) {
                this.removeContentGraphs(this.conversation, msg);
                if (this.logger.isDebugEnabled()) {
                    msg.getRejectsRefs().forEach(other -> this.logger.debug("{} rejects {}", (Object)msg.getMessageURI(), (Object)other.getMessageURI()));
                }
                msg.getRejectsRefs().stream().filter(other -> msg != other).filter(other -> other.isProposesMessage() || other.isProposesToCancelMessage()).filter(other -> other.isHeadOfDeliveryChain()).filter(other -> !other.getSenderNeedURI().equals(msg.getSenderNeedURI())).filter(other -> msg.isMessageOnPathToRoot((ConversationMessage)other)).filter(other -> !msg.accepts((ConversationMessage)other)).forEach(other -> {
                    boolean changedSomething;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("{} rejects {}: valid, computing effects", (Object)msg.getMessageURI(), (Object)other.getMessageURI());
                    }
                    if (changedSomething = this.rejectProposal(other.getMessageURI())) {
                        effectsBuilder.rejects(other.getMessageURI());
                    }
                });
            }
            if (msg.isProposesMessage()) {
                if (this.logger.isDebugEnabled()) {
                    msg.getProposesRefs().forEach(other -> this.logger.debug("{} proposes {}", (Object)msg.getMessageURI(), (Object)other.getMessageURI()));
                }
                Model proposalContent = ModelFactory.createDefaultModel();
                msg.getProposesRefs().stream().filter(other -> msg != other).filter(other -> other.isHeadOfDeliveryChain()).filter(other -> msg.isMessageOnPathToRoot((ConversationMessage)other)).forEach(other -> {
                    boolean changedSomething;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("{} proposes {}: valid, computing effects", (Object)msg.getMessageURI(), (Object)other.getMessageURI());
                    }
                    if (changedSomething = this.propose(conversationDataset, other.getContentGraphs(), proposalContent)) {
                        effectsBuilder.proposes(other.getMessageURI());
                    }
                });
                this.pendingProposals.addNamedModel(msg.getMessageURI().toString(), proposalContent);
            }
            if (msg.isAcceptsMessage()) {
                if (this.logger.isDebugEnabled()) {
                    msg.getAcceptsRefs().forEach(other -> this.logger.debug("{} accepts {}", (Object)msg.getMessageURI(), (Object)other.getMessageURI()));
                }
                msg.getAcceptsRefs().stream().filter(other -> msg != other).filter(other -> other.isHeadOfDeliveryChain()).filter(other -> !other.getSenderNeedURI().equals(msg.getSenderNeedURI())).filter(other -> msg.isMessageOnPathToRoot((ConversationMessage)other)).filter(other -> !msg.rejects((ConversationMessage)other)).forEach(other -> {
                    boolean changedSomething;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("{} accepts {}: valid, computing effects", (Object)msg.getMessageURI(), (Object)other.getMessageURI());
                    }
                    if (changedSomething = this.acceptProposal(other.getMessageURI())) {
                        effectsBuilder.accepts(other.getMessageURI(), other.getProposesToCancel().stream().collect(Collectors.toSet()));
                    }
                });
            }
            if (msg.isProposesToCancelMessage()) {
                if (this.logger.isDebugEnabled()) {
                    msg.getProposesToCancelRefs().forEach(other -> this.logger.debug("{} proposesToCancel {}", (Object)msg.getMessageURI(), (Object)other.getMessageURI()));
                }
                Model cancellationProposals = this.pendingProposals.getDefaultModel();
                msg.getProposesToCancelRefs().stream().filter(other -> msg != other).filter(other -> other.isHeadOfDeliveryChain()).filter(toCancel -> msg.isMessageOnPathToRoot((ConversationMessage)toCancel)).forEach(other -> {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("{} proposesToCancel {}: valid, computing effects", (Object)msg.getMessageURI(), (Object)other.getMessageURI());
                    }
                    cancellationProposals.add((Statement)new StatementImpl(cancellationProposals.getResource(msg.getMessageURI().toString()), WONAGR.PROPOSES_TO_CANCEL, (RDFNode)cancellationProposals.getResource(other.getMessageURI().toString())));
                    this.pendingProposals.setDefaultModel(cancellationProposals);
                    effectsBuilder.proposesToCancel(other.getMessageURI());
                });
            }
            msg.setEffects(effectsBuilder.build());
            if (!this.logger.isDebugEnabled() || msg.getEffects().isEmpty()) continue;
            this.logger.debug("Effects of message {} : {}", (Object)msg.getMessageURI(), msg.getEffects());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("messages in the order they were processed:");
            if (processedInOrder != null) {
                processedInOrder.stream().forEach(x -> this.logger.debug(x.toString()));
            }
            this.logger.debug("finished conversation analysis for high-level protocols");
        }
        this.pendingProposals.commit();
        this.agreements.commit();
        this.cancelledAgreements.commit();
        this.rejected.commit();
        conversationDataset.end();
    }

    private void throwExceptionIfOtherisMissing(URI messageUri, URI otherMessageUri, ConversationMessage otherMessage, String predicate) {
        if (otherMessage != null) {
            return;
        }
        throw new IncompleteConversationDataException(messageUri, otherMessageUri, predicate);
    }

    private Dataset acknowledgedSelection(Dataset conversationDataset, Collection<ConversationMessage> messages) {
        Dataset copy = RdfUtils.cloneDataset((Dataset)conversationDataset);
        messages.stream().forEach(message -> {
            if (message.getMessageType() == null) {
                return;
            }
            if (message.getDirection() == WonMessageDirection.FROM_EXTERNAL) {
                return;
            }
            if (message.getDirection() == WonMessageDirection.FROM_SYSTEM && !message.isResponse()) {
                if (!message.isAcknowledgedLocally()) {
                    this.notAcknowledged(copy, (ConversationMessage)message);
                }
                return;
            }
            if (!message.isHeadOfDeliveryChain()) {
                return;
            }
            switch (message.getMessageType()) {
                case SUCCESS_RESPONSE: 
                case FAILURE_RESPONSE: {
                    break;
                }
                case CREATE_NEED: 
                case HINT_FEEDBACK_MESSAGE: 
                case DEACTIVATE: 
                case ACTIVATE: 
                case HINT_MESSAGE: {
                    if (message.isAcknowledgedLocally()) break;
                    this.notAcknowledged(copy, (ConversationMessage)message);
                    break;
                }
                case CONNECT: 
                case OPEN: 
                case CONNECTION_MESSAGE: 
                case CLOSE: {
                    if (message.isAcknowledgedRemotely()) break;
                    this.notAcknowledged(copy, (ConversationMessage)message);
                }
            }
            DeliveryChain msgChain = message.getDeliveryChain();
            if (msgChain.containsOtherChains()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ignoring delivery chain {} as it contains other chains", (Object)msgChain.getHeadURI());
                }
                this.notAcknowledged(copy, (ConversationMessage)message);
            } else {
                msgChain.getInterleavedDeliveryChains().stream().filter(otherChain -> otherChain.isTerminated()).forEach(otherChain -> {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("dropping delivery chain {} as it is interleaved with {}", (Object)message.getMessageURI(), (Object)otherChain.getHead().getMessageURI());
                    }
                    this.notAcknowledged(copy, (ConversationMessage)message);
                });
            }
        });
        return copy;
    }

    private void notAcknowledged(Dataset copy, ConversationMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("not acknowledged: " + message.getMessageURI());
        }
        message.removeHighlevelProtocolProperties();
        this.removeContentGraphs(copy, message);
    }

    private boolean removeContentGraphs(Dataset conversationDataset, ConversationMessage message) {
        AtomicBoolean changedSomething = new AtomicBoolean(false);
        message.getContentGraphs().stream().forEach(uri -> {
            String uriString = uri.toString();
            if (conversationDataset.containsNamedModel(uriString)) {
                conversationDataset.removeNamedModel(uriString);
            }
            changedSomething.set(true);
        });
        return changedSomething.get();
    }

    private boolean propose(Dataset conversationDataset, Collection<URI> graphURIs, Model proposal) {
        long initialSize = proposal.size();
        graphURIs.forEach(uri -> {
            Model graph = conversationDataset.getNamedModel(uri.toString());
            if (graph != null) {
                proposal.add(RdfUtils.cloneModel((Model)graph));
            }
        });
        return proposal.size() - initialSize > 0L;
    }

    private boolean acceptProposal(URI proposalUri) {
        boolean changedSomething = false;
        Model cancellationProposals = this.pendingProposals.getDefaultModel();
        NodeIterator nIt = cancellationProposals.listObjectsOfProperty(cancellationProposals.getResource(proposalUri.toString()), WONAGR.PROPOSES_TO_CANCEL);
        if (nIt.hasNext()) {
            this.acceptedCancellationProposalUris.add(proposalUri);
            changedSomething = true;
        }
        while (nIt.hasNext()) {
            RDFNode agreementToCancelUri = nIt.next();
            changedSomething = this.cancelAgreement(URI.create(agreementToCancelUri.asResource().getURI())) || changedSomething;
        }
        changedSomething = this.removeCancellationProposal(proposalUri) || changedSomething;
        changedSomething = this.moveNamedGraph(proposalUri, this.pendingProposals, this.agreements) || changedSomething;
        return changedSomething;
    }

    private boolean retractProposal(URI proposalUri) {
        boolean changedSomething = false;
        if (this.pendingProposals.containsNamedModel(proposalUri.toString())) {
            changedSomething = true;
        }
        this.pendingProposals.removeNamedModel(proposalUri.toString());
        changedSomething = this.removeCancellationProposal(proposalUri) || changedSomething;
        return changedSomething;
    }

    private boolean rejectProposal(URI proposalUri) {
        boolean changedSomething = this.moveNamedGraph(proposalUri, this.pendingProposals, this.rejected);
        changedSomething = this.removeCancellationProposal(proposalUri) || changedSomething;
        return changedSomething;
    }

    private boolean cancelAgreement(URI toCancel) {
        return this.moveNamedGraph(toCancel, this.agreements, this.cancelledAgreements);
    }

    private boolean removeCancellationProposal(URI proposalUri) {
        boolean changedSomething = false;
        Model cancellationProposals = this.pendingProposals.getDefaultModel();
        StmtIterator it = cancellationProposals.listStatements(cancellationProposals.getResource(proposalUri.toString()), WONAGR.PROPOSES_TO_CANCEL, (RDFNode)null);
        changedSomething = it.hasNext();
        cancellationProposals.remove(it);
        return changedSomething;
    }

    private boolean moveNamedGraph(URI graphUri, Dataset fromDataset, Dataset toDataset) {
        boolean changedSomething = false;
        Model model = fromDataset.getNamedModel(graphUri.toString());
        fromDataset.removeNamedModel(graphUri.toString());
        if (model != null && model.size() > 0L) {
            toDataset.addNamedModel(graphUri.toString(), model);
            changedSomething = true;
        }
        return changedSomething;
    }
}

