/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import won.owner.service.impl.NopOwnerApplicationServiceCallback;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.sender.WonMessageSender;
import won.protocol.message.sender.exception.WonMessageSenderException;

public class OwnerApplicationService
implements WonMessageProcessor,
WonMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    @Qualifier(value="default")
    private WonMessageSender wonMessageSenderDelegate;
    private WonMessageProcessor messageProcessorDelegate = new NopOwnerApplicationServiceCallback();

    public WonMessage prepareMessage(WonMessage message) throws WonMessageSenderException {
        return this.wonMessageSenderDelegate.prepareMessage(message);
    }

    public void sendMessage(WonMessage wonMessage) {
        try {
            this.wonMessageSenderDelegate.sendMessage(wonMessage);
        }
        catch (Exception e) {
            logger.info("could not send WonMessage", (Throwable)e);
        }
    }

    public void prepareAndSendMessage(WonMessage message) throws WonMessageSenderException {
        this.sendMessage(this.prepareMessage(message));
    }

    public WonMessage process(WonMessage wonMessage) {
        return this.messageProcessorDelegate.process(wonMessage);
    }

    public void setMessageProcessorDelegate(WonMessageProcessor messageProcessorDelegate) {
        this.messageProcessorDelegate = messageProcessorDelegate;
    }
}

