/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class KeystorePasswordUtils {
    public static final String CURRENT_VERSION = "v1";
    public static final int KEYSTORE_PASSWORD_BYTES = 32;

    public static String encryptPassword(String password, String key) {
        try {
            int iterations = 1000;
            byte[] salt = KeystorePasswordUtils.getSalt();
            byte[] iv = KeystorePasswordUtils.getSalt();
            PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), salt, iterations, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] encryptionKey = skf.generateSecret(spec).getEncoded();
            SecretKeySpec secretKey = new SecretKeySpec(encryptionKey, "AES");
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm() + "/CFB8/NoPadding");
            cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
            return "v1:" + iterations + ":" + KeystorePasswordUtils.toHex(salt) + ":" + KeystorePasswordUtils.toHex(iv) + ":" + KeystorePasswordUtils.toHex(cipher.doFinal(password.getBytes()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot encrypt password", e);
        }
    }

    public static String decryptPassword(String encrypted, String key) {
        try {
            String[] chunks = encrypted.split(":");
            String versionStr = chunks[0];
            String iterationsStr = chunks[1];
            String saltStr = chunks[2];
            String ivStr = chunks[3];
            String toDecryptStr = chunks[4];
            int iterations = Integer.valueOf(iterationsStr);
            byte[] salt = KeystorePasswordUtils.fromHex(saltStr);
            byte[] iv = KeystorePasswordUtils.fromHex(ivStr);
            byte[] toDecrypt = KeystorePasswordUtils.fromHex(toDecryptStr);
            PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), salt, iterations, 256);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] encryptionKey = skf.generateSecret(spec).getEncoded();
            SecretKeySpec secretKey = new SecretKeySpec(encryptionKey, "AES");
            Cipher cipher = Cipher.getInstance(secretKey.getAlgorithm() + "/CFB8/NoPadding");
            cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
            return new String(cipher.doFinal(toDecrypt));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("cannot decrypt password", e);
        }
    }

    public static String generatePassword(String toHash, int hashLength) {
        try {
            int iterations = 1000;
            char[] chars = toHash.toCharArray();
            byte[] salt = KeystorePasswordUtils.getSalt();
            PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, hashLength);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            byte[] hash = skf.generateSecret(spec).getEncoded();
            return "v1:" + iterations + ":" + KeystorePasswordUtils.toHex(salt) + ":" + Base64.getEncoder().encodeToString(hash);
        }
        catch (Exception e) {
            throw new RuntimeException("could not generate key", e);
        }
    }

    public static String generatePassword(int passwordBytes) {
        try {
            SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
            byte[] password = new byte[passwordBytes];
            sr.nextBytes(password);
            return Base64.getEncoder().encodeToString(password);
        }
        catch (Exception e) {
            throw new RuntimeException("could not generate key", e);
        }
    }

    private static byte[] getSalt() throws NoSuchAlgorithmException {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[16];
        sr.nextBytes(salt);
        return salt;
    }

    private static byte[] padSalt(byte[] toPad) {
        byte[] salt = new byte[16];
        System.arraycopy(toPad, 0, salt, 0, Math.min(toPad.length, salt.length));
        return salt;
    }

    private static String toHex(byte[] array) {
        return DatatypeConverter.printHexBinary((byte[])array);
    }

    private static byte[] fromHex(String hexString) {
        return DatatypeConverter.parseHexBinary((String)hexString);
    }
}

