/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import java.security.KeyStore;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import won.owner.model.KeystoreHolder;
import won.owner.model.KeystorePasswordHolder;
import won.owner.model.User;
import won.owner.repository.KeystoreHolderRepository;
import won.owner.repository.KeystorePasswordRepository;
import won.owner.repository.UserRepository;
import won.owner.service.impl.KeystoreEnabledUserDetails;
import won.owner.service.impl.KeystorePasswordUtils;

public class KeystoreEnabledDaoAuthenticationProvider
extends DaoAuthenticationProvider {
    @Autowired
    UserRepository userRepository;
    @Autowired
    KeystoreHolderRepository keystoreHolderRepository;
    @Autowired
    KeystorePasswordRepository keystorePasswordRepository;

    @Transactional
    public Authentication authenticate(Authentication authentication) {
        String password = (String)authentication.getCredentials();
        String username = (String)authentication.getPrincipal();
        UsernamePasswordAuthenticationToken auth = (UsernamePasswordAuthenticationToken)super.authenticate(authentication);
        User user = (User)auth.getPrincipal();
        KeystorePasswordHolder keystorePasswordHolder = (user = (User)this.userRepository.findOne(user.getId())).getKeystorePasswordHolder();
        if (keystorePasswordHolder == null || keystorePasswordHolder.getEncryptedPassword() == null || keystorePasswordHolder.getEncryptedPassword().length() == 0) {
            keystorePasswordHolder = new KeystorePasswordHolder();
            keystorePasswordHolder.setPassword(KeystorePasswordUtils.generatePassword(32), password);
            user.setKeystorePasswordHolder(keystorePasswordHolder);
        }
        String keystorePassword = keystorePasswordHolder.getPassword(password);
        KeystoreHolder keystoreHolder = user.getKeystoreHolder();
        KeyStore keystore = null;
        if (keystoreHolder == null || keystoreHolder.getKeystoreBytes() == null || keystoreHolder.getKeystoreBytes().length == 0) {
            keystoreHolder = new KeystoreHolder();
            keystore = this.openOrCreateKeyStore(keystorePassword, auth.getName(), keystoreHolder);
            user.setKeystoreHolder(keystoreHolder);
        } else {
            try {
                keystore = keystoreHolder.getKeystore(keystorePassword);
            }
            catch (Exception e) {
                throw new IllegalStateException("could not open keystore for user " + username);
            }
        }
        this.userRepository.save(user);
        KeystoreEnabledUserDetails ud = new KeystoreEnabledUserDetails(user, keystore, keystorePassword);
        return new UsernamePasswordAuthenticationToken((Object)ud, null, auth.getAuthorities());
    }

    private KeyStore openOrCreateKeyStore(String password, String username, KeystoreHolder keystoreHolder) {
        KeyStore keystore = null;
        try {
            keystore = keystoreHolder.getKeystore(password);
        }
        catch (Exception e) {
            throw new IllegalStateException("could not open keystore for user " + username);
        }
        return keystore;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void setKeystoreHolderRepository(KeystoreHolderRepository keystoreHolderRepository) {
        this.keystoreHolderRepository = keystoreHolderRepository;
    }
}

