/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message.base;

import java.net.URI;
import java.util.Optional;
import org.apache.jena.query.Dataset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import won.owner.protocol.message.OwnerCallback;
import won.owner.protocol.message.base.OwnerCallbackAdapter;
import won.protocol.message.WonMessage;
import won.protocol.model.Connection;
import won.protocol.util.WonRdfUtils;
import won.protocol.util.linkeddata.LinkedDataSource;
import won.protocol.util.linkeddata.WonLinkedDataUtils;

public class MessageExtractingOwnerCallbackAdapter
extends OwnerCallbackAdapter {
    @Autowired
    private LinkedDataSource linkedDataSource;

    public MessageExtractingOwnerCallbackAdapter(OwnerCallback adaptee) {
        super(adaptee);
    }

    public MessageExtractingOwnerCallbackAdapter() {
    }

    @Override
    protected Connection makeConnection(WonMessage wonMessage) {
        return this.toConnection(wonMessage);
    }

    private Connection toConnection(WonMessage wonMessage) {
        Optional connectionUri = WonLinkedDataUtils.getConnectionURIForIncomingMessage((WonMessage)wonMessage, (LinkedDataSource)this.linkedDataSource);
        if (connectionUri.isPresent()) {
            Dataset ds = this.linkedDataSource.getDataForResource((URI)connectionUri.get());
            return WonRdfUtils.ConnectionUtils.getConnection((Dataset)ds, (URI)((URI)connectionUri.get()));
        }
        return null;
    }

    @Override
    @Autowired(required=false)
    @Qualifier(value="default")
    public void setAdaptee(OwnerCallback adaptee) {
        super.setAdaptee(adaptee);
    }
}

