/*
 * Decompiled with CFR 0.152.
 */
package won.owner.messaging;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import won.owner.messaging.OwnerProtocolCommunicationServiceImpl;
import won.owner.messaging.WonNodeRegistrationEvent;
import won.protocol.jms.MessagingService;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageEncoder;
import won.protocol.message.WonMessageUtils;
import won.protocol.message.processor.impl.KeyForNewAtomAddingProcessor;
import won.protocol.message.processor.impl.SignatureAddingWonMessageProcessor;
import won.protocol.message.sender.WonMessageSender;
import won.protocol.message.sender.exception.WonMessageSenderException;
import won.protocol.model.WonNode;
import won.protocol.repository.WonNodeRepository;
import won.protocol.util.LoggingUtils;
import won.protocol.util.RdfUtils;

public class OwnerWonMessageSenderJMSBased
implements ApplicationListener<WonNodeRegistrationEvent>,
WonMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean isDefaultWonNodeRegistered = false;
    private MessagingService messagingService;
    private URI defaultNodeURI;
    private String startingEndpoint;
    @Autowired
    private OwnerProtocolCommunicationServiceImpl ownerProtocolCommunicationServiceImpl;
    @Autowired
    private WonNodeRepository wonNodeRepository;
    @Autowired
    private SignatureAddingWonMessageProcessor signatureAddingProcessor;
    @Autowired
    private KeyForNewAtomAddingProcessor atomKeyGeneratorAndAdder;

    public void prepareAndSendMessage(WonMessage message) throws WonMessageSenderException {
        this.sendMessage(this.prepareMessage(message));
    }

    public WonMessage prepareMessage(WonMessage message) throws WonMessageSenderException {
        try {
            return this.doSigningOnOwner(message);
        }
        catch (Exception e) {
            throw new WonMessageSenderException("Could not sign message or calculate its URI", (Throwable)e);
        }
    }

    public void sendMessage(WonMessage wonMessage) {
        try {
            URI msgUri;
            if (logger.isDebugEnabled()) {
                logger.debug("sending this message: {}", (Object)RdfUtils.writeDatasetToString((Dataset)wonMessage.getCompleteDataset(), (Lang)Lang.TRIG));
            }
            if (!WonMessageUtils.isValidMessageUri((URI)(msgUri = wonMessage.getMessageURIRequired()))) {
                throw new WonMessageSenderException("Not a valid message uri: " + msgUri + ". Did you call prepareMessage(message) first?");
            }
            URI wonNodeUri = wonMessage.getSenderNodeURI();
            if (wonNodeUri == null) {
                throw new IllegalStateException("a message needs a SenderNodeUri otherwise we can't determine the won node via which to send it");
            }
            String ep = this.ownerProtocolCommunicationServiceImpl.getProtocolCamelConfigurator().getEndpoint(wonNodeUri);
            if (ep == null) {
                if (!this.ownerProtocolCommunicationServiceImpl.isRegisteredWithWonNode(wonNodeUri)) {
                    this.ownerProtocolCommunicationServiceImpl.register(wonNodeUri, this.messagingService);
                }
                if ((ep = this.ownerProtocolCommunicationServiceImpl.getProtocolCamelConfigurator().getEndpoint(wonNodeUri)) == null) {
                    throw new Exception("could not obtain camel endpoint for WoN node " + wonNodeUri + " even after trying to re-register");
                }
            }
            List wonNodeList = this.wonNodeRepository.findByWonNodeURI(wonNodeUri);
            String ownerApplicationId = ((WonNode)wonNodeList.get(0)).getOwnerApplicationID();
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("won.ownerApplicationId", ownerApplicationId);
            headerMap.put("won.remoteBrokerEndpoint", ep);
            this.messagingService.sendInOnlyMessage(null, headerMap, (Object)WonMessageEncoder.encode((WonMessage)wonMessage, (Lang)Lang.TRIG), this.startingEndpoint);
        }
        catch (Exception e) {
            throw new RuntimeException("could not send message", e);
        }
    }

    private WonMessage doSigningOnOwner(WonMessage wonMessage) throws Exception {
        WonMessage outMessage = this.atomKeyGeneratorAndAdder.process(wonMessage);
        return this.signatureAddingProcessor.signWithAtomKey(outMessage);
    }

    public void onApplicationEvent(WonNodeRegistrationEvent wonNodeRegistrationEvent) {
        if (!this.isDefaultWonNodeRegistered) {
            try {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            logger.info("register at default won node {}", (Object)OwnerWonMessageSenderJMSBased.this.defaultNodeURI);
                            OwnerWonMessageSenderJMSBased.this.ownerProtocolCommunicationServiceImpl.register(OwnerWonMessageSenderJMSBased.this.defaultNodeURI, OwnerWonMessageSenderJMSBased.this.messagingService);
                            logger.info("successfully registered at default won node {}", (Object)OwnerWonMessageSenderJMSBased.this.defaultNodeURI);
                            OwnerWonMessageSenderJMSBased.this.isDefaultWonNodeRegistered = true;
                        }
                        catch (Exception e) {
                            LoggingUtils.logMessageAsInfoAndStacktraceAsDebug((Logger)logger, (Exception)e, (String)"Could not register with default won node {}. Try again later.", (Object[])new Object[]{OwnerWonMessageSenderJMSBased.this.defaultNodeURI});
                        }
                    }
                }.start();
            }
            catch (Exception e) {
                LoggingUtils.logMessageAsInfoAndStacktraceAsDebug((Logger)logger, (Exception)e, (String)"Could not register with default won node {}. Try again later.", (Object[])new Object[]{this.defaultNodeURI});
            }
        }
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public void setDefaultNodeURI(URI defaultNodeURI) {
        this.defaultNodeURI = defaultNodeURI;
    }

    public void setStartingEndpoint(String startingEndpoint) {
        this.startingEndpoint = startingEndpoint;
    }
}

