/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import java.lang.invoke.MethodHandles;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import won.owner.model.EmailVerificationToken;
import won.owner.model.KeyStoreIOException;
import won.owner.model.KeystoreHolder;
import won.owner.model.KeystorePasswordHolder;
import won.owner.model.PushSubscription;
import won.owner.model.User;
import won.owner.repository.EmailVerificationRepository;
import won.owner.repository.KeystorePasswordRepository;
import won.owner.repository.PersistentLoginRepository;
import won.owner.repository.PushSubscriptionRepository;
import won.owner.repository.UserRepository;
import won.owner.service.impl.IncorrectPasswordException;
import won.owner.service.impl.KeystorePasswordUtils;
import won.owner.service.impl.UserAlreadyExistsException;
import won.owner.service.impl.UserNotFoundException;
import won.protocol.util.ExpensiveSecureRandomString;

@Service
public class UserService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private EmailVerificationRepository emailVerificationRepository;
    @Autowired
    private PersistentLoginRepository persistentLoginRepository;
    @Autowired
    private PushSubscriptionRepository pushSubscriptionRepository;
    @Autowired
    private KeystorePasswordRepository keystorePasswordRepository;
    private ExpensiveSecureRandomString randomStringGenerator = new ExpensiveSecureRandomString();

    public User transferUser(String newEmail, String newPassword, String privateUsername, String privatePassword) throws UserAlreadyExistsException, UserNotFoundException {
        return this.transferUser(newEmail, newPassword, privateUsername, privatePassword, null);
    }

    public User transferUser(String newEmail, String newPassword, String privateUsername, String privatePassword, String role) throws UserAlreadyExistsException, UserNotFoundException {
        User user = this.getByUsername(newEmail);
        if (user != null) {
            throw new UserAlreadyExistsException();
        }
        try {
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            User privateUser = this.getByUsernameWithKeystorePassword(privateUsername);
            if (privateUser == null) {
                throw new UserNotFoundException();
            }
            privateUser.setUsername(newEmail);
            privateUser.setPassword(passwordEncoder.encode((CharSequence)newPassword));
            privateUser.setEmail(newEmail);
            privateUser.setEmailVerified(false);
            privateUser.setPrivateId(null);
            privateUser.setAcceptedTermsOfService(true);
            if (role != null) {
                privateUser.setRole(role);
            }
            KeystorePasswordHolder privateKeystorePassword = privateUser.getKeystorePasswordHolder();
            String keystorePassword = privateKeystorePassword.getPassword(privatePassword);
            KeystorePasswordHolder newKeystorePassword = new KeystorePasswordHolder();
            newKeystorePassword.setPassword(keystorePassword, newPassword);
            privateUser.setKeystorePasswordHolder(newKeystorePassword);
            privateUser.setRecoverableKeystorePasswordHolder(null);
            this.save(privateUser);
            return privateUser;
        }
        catch (DataIntegrityViolationException e) {
            throw new UserAlreadyExistsException();
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public User changePassword(String username, String newPassword, String oldPassword) throws UserNotFoundException, KeyStoreIOException, IncorrectPasswordException {
        logger.debug("changing password for user {}", (Object)username);
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        User user = this.getByUsernameWithKeystorePassword(username);
        if (user == null) {
            throw new UserNotFoundException("cannot change password: user not found");
        }
        if (!passwordEncoder.matches((CharSequence)oldPassword, user.getPassword())) {
            throw new IncorrectPasswordException("cannot change password: old password is incorrect");
        }
        KeystorePasswordHolder keystorePasswordHolder = user.getKeystorePasswordHolder();
        String oldKeystorePassword = keystorePasswordHolder.getPassword(oldPassword);
        logger.debug("re-encrypting keystore for user {} with new keystore password", (Object)username);
        String newKeystorePassword = this.changeKeystorePassword(user, oldKeystorePassword);
        user.setPassword(passwordEncoder.encode((CharSequence)newPassword));
        keystorePasswordHolder.setPassword(newKeystorePassword, newPassword);
        user.setKeystorePasswordHolder(keystorePasswordHolder);
        user.setRecoverableKeystorePasswordHolder(null);
        this.save(user);
        logger.debug("password changed for user {}", (Object)username);
        this.persistentLoginRepository.deleteByUsername(username);
        return user;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String generateRecoveryKey(String email, String password) throws UserNotFoundException, IncorrectPasswordException {
        logger.debug("changing password for user {}", (Object)email);
        User user = this.getByUsernameWithKeystorePassword(email);
        if (user == null) {
            throw new UserNotFoundException("cannot generate recovery key: user not found");
        }
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        if (!passwordEncoder.matches((CharSequence)password, user.getPassword())) {
            throw new IncorrectPasswordException("cannot generate recovery key: incorrect password");
        }
        KeystorePasswordHolder keystorePasswordHolder = user.getKeystorePasswordHolder();
        KeystoreHolder keystoreHolder = user.getKeystoreHolder();
        String keystorePassword = keystorePasswordHolder.getPassword(password);
        StringBuilder sb = new StringBuilder();
        sb.append("MY__").append(this.randomStringGenerator.nextString(4)).append("_").append(this.randomStringGenerator.nextString(4)).append("_").append(this.randomStringGenerator.nextString(4)).append("_").append(this.randomStringGenerator.nextString(4)).append("__KEY");
        String recoveryKey = sb.toString();
        KeystorePasswordHolder recoverableKeystorePasswordHolder = new KeystorePasswordHolder();
        recoverableKeystorePasswordHolder.setPassword(keystorePassword, recoveryKey);
        this.keystorePasswordRepository.save(recoverableKeystorePasswordHolder);
        user.setRecoverableKeystorePasswordHolder(recoverableKeystorePasswordHolder);
        this.userRepository.save(user);
        return recoveryKey;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public User useRecoveryKey(String username, String newPassword, String recoveryKey) throws UserNotFoundException, KeyStoreIOException, IncorrectPasswordException {
        logger.debug("using recoery key to reset password for user {}", (Object)username);
        BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
        User user = this.getByUsernameWithKeystorePassword(username);
        if (user == null) {
            throw new UserNotFoundException("cannot change password: user not found");
        }
        KeystorePasswordHolder keystorePasswordHolder = user.getRecoverableKeystorePasswordHolder();
        String oldKeystorePassword = keystorePasswordHolder.getPassword(recoveryKey);
        logger.debug("re-encrypting keystore for user {} with new keystore password", (Object)username);
        String newKeystorePassword = this.changeKeystorePassword(user, oldKeystorePassword);
        user.setKeystorePasswordHolder(keystorePasswordHolder);
        user.getKeystorePasswordHolder().setPassword(newKeystorePassword, newPassword);
        user.setPassword(passwordEncoder.encode((CharSequence)newPassword));
        user.setRecoverableKeystorePasswordHolder(null);
        this.save(user);
        logger.debug("password changed for user {}", (Object)username);
        this.persistentLoginRepository.deleteByUsername(username);
        return user;
    }

    private String changeKeystorePassword(User user, String oldKeystorePassword) throws KeyStoreIOException {
        String newKeystorePassword = KeystorePasswordUtils.generatePassword(32);
        KeyStore keyStore = user.getKeystoreHolder().getKeystore(oldKeystorePassword);
        try {
            Enumeration<String> aliases = keyStore.aliases();
            try {
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    if (keyStore.isKeyEntry(alias)) {
                        Key key = keyStore.getKey(alias, oldKeystorePassword.toCharArray());
                        Certificate[] chain = keyStore.getCertificateChain(alias);
                        keyStore.setKeyEntry(alias, key, newKeystorePassword.toCharArray(), chain);
                    } else if (keyStore.isCertificateEntry(alias)) {
                        // empty if block
                    }
                    logger.debug("re-encrypted key for alias: {} ", (Object)alias);
                }
            }
            catch (UnrecoverableKeyException e) {
                throw new KeyStoreIOException("could not re-encrypt key", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyStoreIOException("could not re-encrypt key", e);
            }
        }
        catch (KeyStoreException e) {
            throw new KeyStoreIOException("could not re-encrypt key", e);
        }
        user.getKeystoreHolder().setKeystore(keyStore, newKeystorePassword);
        return newKeystorePassword;
    }

    public User registerUser(String email, String password, String role) throws UserAlreadyExistsException {
        return this.registerUser(email, password, role, null);
    }

    public User registerUser(String email, String password, String role, String privateId) throws UserAlreadyExistsException {
        User user = this.getByUsername(email);
        if (user != null) {
            throw new UserAlreadyExistsException();
        }
        try {
            BCryptPasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
            user = new User(email, passwordEncoder.encode((CharSequence)password), role);
            user.setEmail(email);
            if (privateId != null) {
                user.setPrivateId(privateId);
            }
            user.setAcceptedTermsOfService(true);
            KeystorePasswordHolder keystorePassword = new KeystorePasswordHolder();
            keystorePassword.setPassword(KeystorePasswordUtils.generatePassword(32), password);
            KeystoreHolder keystoreHolder = new KeystoreHolder();
            try {
                keystoreHolder.getKeystore(keystorePassword.getPassword(password));
            }
            catch (Exception e) {
                throw new IllegalStateException("could not create keystore for user " + email);
            }
            user.setKeystorePasswordHolder(keystorePassword);
            user.setKeystoreHolder(keystoreHolder);
            this.save(user);
            return user;
        }
        catch (DataIntegrityViolationException e) {
            throw new UserAlreadyExistsException();
        }
    }

    public User getByUsername(String username) {
        return this.userRepository.findByUsername(username);
    }

    public User getByUsernameWithKeystorePassword(String username) {
        return this.userRepository.findByUsernameWithKeystorePassword(username);
    }

    public EmailVerificationToken getEmailVerificationToken(String verificationToken) {
        return this.emailVerificationRepository.findByToken(verificationToken);
    }

    public EmailVerificationToken getEmailVerificationToken(User user) {
        List<EmailVerificationToken> tokens = this.emailVerificationRepository.findByUser(user);
        for (EmailVerificationToken token : tokens) {
            if (token.isExpired()) continue;
            return token;
        }
        return null;
    }

    public EmailVerificationToken createEmailVerificationToken(User user) {
        return this.createEmailVerificationToken(user, UUID.randomUUID().toString());
    }

    public EmailVerificationToken createEmailVerificationToken(User user, String verificationToken) {
        EmailVerificationToken token = new EmailVerificationToken(user, verificationToken);
        this.emailVerificationRepository.save(token);
        return token;
    }

    public User getUserByEmailVerificationToken(String verificationToken) {
        return this.getEmailVerificationToken(verificationToken).getUser();
    }

    public void save(User user) {
        this.userRepository.save(user);
    }

    public void addPushSubscription(User user, PushSubscription subscription) {
        user.addPushSubscription(subscription);
        this.save(user);
    }
}

