/*
 * Decompiled with CFR 0.152.
 */
package won.owner.service.impl;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import won.owner.service.impl.NopOwnerApplicationServiceCallback;
import won.protocol.message.WonMessage;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.sender.WonMessageSender;

public class OwnerApplicationService
implements WonMessageProcessor,
WonMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Autowired
    @Qualifier(value="default")
    private WonMessageSender wonMessageSenderDelegate;
    private WonMessageProcessor messageProcessorDelegate = new NopOwnerApplicationServiceCallback();

    public void sendWonMessage(WonMessage wonMessage) {
        try {
            this.wonMessageSenderDelegate.sendWonMessage(wonMessage);
        }
        catch (Exception e) {
            logger.info("could not send WonMessage", (Throwable)e);
        }
    }

    public WonMessage process(WonMessage wonMessage) {
        return this.messageProcessorDelegate.process(wonMessage);
    }

    public void setMessageProcessorDelegate(WonMessageProcessor messageProcessorDelegate) {
        this.messageProcessorDelegate = messageProcessorDelegate;
    }
}

