/*
 * Decompiled with CFR 0.152.
 */
package won.owner.protocol.message.base;

import java.lang.invoke.MethodHandles;
import org.apache.jena.query.Dataset;
import org.apache.jena.riot.Lang;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import won.owner.protocol.message.OwnerCallback;
import won.protocol.message.WonMessage;
import won.protocol.message.WonMessageType;
import won.protocol.message.processor.WonMessageProcessor;
import won.protocol.message.processor.exception.WonMessageProcessingException;
import won.protocol.model.Connection;
import won.protocol.util.RdfUtils;

public abstract class OwnerCallbackAdapter
implements WonMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private OwnerCallback adaptee;

    protected OwnerCallbackAdapter() {
    }

    public OwnerCallbackAdapter(OwnerCallback adaptee) {
        this.adaptee = adaptee;
    }

    protected abstract Connection makeConnection(WonMessage var1);

    public WonMessage process(WonMessage message) throws WonMessageProcessingException {
        assert (this.adaptee != null) : "adaptee is not set";
        logger.debug("processing message {} and calling appropriate method on adaptee", (Object)message.getMessageURI());
        WonMessageType messageType = message.getMessageType();
        switch (messageType) {
            case ATOM_HINT_MESSAGE: {
                this.adaptee.onAtomHintFromMatcher(message);
                break;
            }
            case SOCKET_HINT_MESSAGE: {
                this.adaptee.onSocketHintFromMatcher(message);
                break;
            }
            case CONNECT: {
                this.adaptee.onConnectFromOtherAtom(this.makeConnection(message), message);
                break;
            }
            case OPEN: {
                this.adaptee.onOpenFromOtherAtom(this.makeConnection(message), message);
                break;
            }
            case CONNECTION_MESSAGE: {
                this.adaptee.onMessageFromOtherAtom(this.makeConnection(message), message);
                break;
            }
            case CLOSE: {
                this.adaptee.onCloseFromOtherAtom(this.makeConnection(message), message);
                break;
            }
            case SUCCESS_RESPONSE: {
                this.adaptee.onSuccessResponse(message.getIsResponseToMessageURI(), message);
                break;
            }
            case FAILURE_RESPONSE: {
                this.adaptee.onFailureResponse(message.getIsResponseToMessageURI(), message);
                break;
            }
            case CREATE_ATOM: {
                logger.debug("Handling CREATE_ATOM for message {}", (Object)message);
                break;
            }
            case DELETE: {
                logger.debug("Handling DELETE for message {}", (Object)message);
                break;
            }
            case REPLACE: {
                logger.debug("Handling REPLACE for message {}", (Object)message);
                break;
            }
            case DEACTIVATE: {
                logger.debug("Handling DEACTIVATE for message {}", (Object)message);
                break;
            }
            default: {
                logger.info("could not find callback method for wonMessage of type {}", (Object)messageType);
                if (!logger.isDebugEnabled()) break;
                logger.debug("message: {}", (Object)RdfUtils.writeDatasetToString((Dataset)message.getCompleteDataset(), (Lang)Lang.TRIG));
            }
        }
        return message;
    }

    @Autowired(required=false)
    @Qualifier(value="default")
    public void setAdaptee(OwnerCallback adaptee) {
        this.adaptee = adaptee;
    }
}

